<?php $__env->startSection('title','Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						<?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<table class="table table-striped view-table">
						  	<thead>
							    <tr>
							      	<td>ID</td>
							      	<td><?php echo e($record->id); ?></td>
							    </tr>
							    <tr>
							      	<td>Status</td>
							      	<td><?php if($record->status==1): ?> Active <?php else: ?> Deactive <?php endif; ?></td>
							    </tr>
							    <tr>
							      	<td>Name (In English)</td>
							      	<td><?php echo e($record->name_eng); ?></td>
							    </tr>
							    <tr>
							      	<td>Name (In Arabic)</td>
							      	<td><?php echo e($record->name_ar); ?></td>
							    </tr>
							    <?php if($record->categories[0]->id): ?>
							    <tr>
							    	<td>Category</td>
							    	<td><?php echo e($record->categories[0]->name_eng); ?></td>
							    </tr>
							    <?php endif; ?>
							    <tr>
							      	<td>Image</td>
							      	<td>
							    		<img class="banner-image" src="<?php echo e(asset('/admin/images/course_images/'.$record->image)); ?>">
							    	</td>
							    </tr>
							    <tr>
							      	<td>Venue (In English)</td>
							      	<td><?php echo e($record->venue_eng); ?></td>
							    </tr>
							    <tr>
							      	<td>Venue (In Arabic)</td>
							      	<td><?php echo e($record->venue_ar); ?></td>
							    </tr>
							    
							    <tr>
							      	<td>Start Date</td>
							      	<td><?php echo e($record->start_date); ?></td>
							    </tr>
							    <tr>
							      	<td>End Date</td>
							      	<td><?php echo e($record->end_date); ?></td>
							    </tr>
							    <tr>
							      	<td>Course Price</td>
							      	<td><?php echo e($record->amount); ?></td>
							    </tr>
							    <tr>
							      	<td>Days</td>
							      	<td><?php echo e($record->days); ?></td>
							    </tr>
							    <tr>
							      	<td>Hours</td>
							      	<td><?php echo e($record->hours); ?></td>
							    </tr>
							    <tr>
							      	<td>About the Course (In English)</td>
							      	<td><?php echo $record->about_course_eng; ?></td>
							    </tr>
							    <tr>
							      	<td>About the Course (In Arabic)</td>
							      	<td><?php echo $record->about_course_ar; ?></td>
							    </tr>
							    <tr>
							      	<td>Prerequisites (In English)</td>
							      	<td><?php echo $record->prerequisites_eng; ?></td>
							    </tr>
							    <tr>
							      	<td>Prerequisites (In Arabic)</td>
							      	<td><?php echo $record->prerequisites_ar; ?></td>
							    </tr>
							    <tr>
							      	<td>Package Includes (In English)</td>
							      	<td><?php echo $record->package_includes_eng; ?></td>
							    </tr>
							    <tr>
							      	<td>Package Includes (In Arabic)</td>
							      	<td><?php echo $record->package_includes_ar; ?></td>
							    </tr>
							    <tr>
							      	<td>Created at</td>
							      	<td><?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')); ?></td>
							    </tr>
							    <?php if($record->meta_title): ?>
							    <tr>
							      	<td>Meta Title</td>
							      	<td><?php echo $record->meta_title; ?></td>
							    </tr>
							    <?php endif; ?>
							    <?php if($record->meta_description): ?>
							    <tr>
							      	<td>Meta Description</td>
							      	<td><?php echo $record->meta_description; ?></td>
							    </tr>
							    <?php endif; ?>
							    <?php if($record->meta_keywords): ?>
							    <tr>
							      	<td>Meta Keywords</td>
							      	<td><?php echo $record->meta_keywords; ?></td>
							    </tr>
							    <?php endif; ?>
							    <tr>
							      	<td colspan="2">
							      		<a href="<?php echo e(route('admin.list_courses')); ?>" class="btn btn-primary">Back</a>
							      	</td>
							    </tr>
						  	</thead>
						  	<tbody>
							    
						  	</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravel-api/resources/views/admin/courses/view.blade.php ENDPATH**/ ?>