<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset=UTF-8>
    <meta name=viewport content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="//stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin=anonymous>
    <link rel="stylesheet" href="<?php echo e(URL::asset('admin/css/app.css')); ?>" />
    <title>Admin</title>
</head>
<body>
    <main class="d-flex w-100">
        <div class="container d-flex flex-column">
            <div class="row vh-100">
                <div class="col-sm-10 col-md-8 col-lg-6 mx-auto d-table h-100">
                    <div class="d-table-cell align-middle">

                        <div class="text-center mt-4">
                            <h1 class="h2">Welcome</h1>
                            <p class="lead">
                                Sign in to your account to continue
                            </p>
                            <?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div class="m-sm-4">
                                    <form id="sign_in_adm" method="POST" action="<?php echo e(route('admin.login.submit')); ?>">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="mb-3">
                                            <label class="form-label">Email</label>
                                            <input class="form-control form-control-lg" type="email" name="email" placeholder="Enter your email" value="<?php echo e(old('email')); ?>" required autofocus />
                                            <?php if($errors->has('email')): ?>
                                                <span ><strong><?php echo e($errors->first('email')); ?></strong></span>
                                            <?php endif; ?>
                                            <br>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Password</label>
                                            <input class="form-control form-control-lg" type="password" name="password" placeholder="Enter your password" required />
                                        </div>
                                        <div class="text-center mt-3">
                                            <button type="submit" class="btn btn-lg btn-primary">Sign in</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </main>
    <script src="<?php echo e(URL::asset('admin/js/app.js')); ?>"></script>
    <script type="text/javascript">
        function removeAlertBlock(el){
            el.parentNode.parentNode.removeChild(el.parentNode)
        }
    </script>
</body>

</html><?php /**PATH C:\Users\Lenovo\Desktop\development\nama medical\laravel-api\resources\views/auth/admin_login.blade.php ENDPATH**/ ?>