<?php $__env->startSection('title','Contact us Settings - Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Settings - Contact us</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						<?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<form method="POST" action="<?php echo e(route('save-contact-settings')); ?>">
							<?php echo e(@csrf_field()); ?>

							<input type="hidden" name="meta_key" value="contact_us">
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Contact info (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="settings[contact_info_eng]"><?php echo e($record['contact_info_eng']); ?></textarea>
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Contact info (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="settings[contact_info_ar]"><?php echo e($record['contact_info_ar']); ?></textarea>
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4 contact-us-members">
								<label class="col-3" for="">Members</label>
								<div class="col-8 list">
									<?php $__currentLoopData = $record['members_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<div class="member">
										<div class="row">
											<div class="col-6">
												<input type="text" class="form-control" name="settings[members][title_eng][]" placeholder="Title in english" value="<?php echo e($member['title_eng']); ?>">
											</div>
											<div class="col-6">
												<input type="text"  class="form-control" name="settings[members][title_ar][]" placeholder="Title in Arabic" value="<?php echo e($member['title_ar']); ?>">
											</div>
											<div class="col-6">
												<input type="text"  class="form-control" name="settings[members][name_eng][]" placeholder="Name in english" value="<?php echo e($member['name_eng']); ?>">
											</div>
											<div class="col-6">
												<input type="text"  class="form-control" name="settings[members][name_ar][]" placeholder="Name in Arabic" value="<?php echo e($member['name_ar']); ?>">
											</div>
											<div class="col-12">
												<input type="email"  class="form-control" name="settings[members][email][]" placeholder="Email" value="<?php echo e($member['email']); ?>">
											</div>
										</div>
										<a href="javascript:;" class="delete-member" title="Delete record">
					                    	X
							    		</a>
									</div>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<a class="add-member btn btn-primary">Add Member</a>
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    var member_block = `<div class="member">
							<div class="row">
								<div class="col-6">
									<input type="text" class="form-control" name="settings[members][title_eng][]" placeholder="Title in english">
								</div>
								<div class="col-6">
									<input type="text"  class="form-control" name="settings[members][title_ar][]" placeholder="Title in Arabic">
								</div>
								<div class="col-6">
									<input type="text"  class="form-control" name="settings[members][name_eng][]" placeholder="Name in english">
								</div>
								<div class="col-6">
									<input type="text"  class="form-control" name="settings[members][name_ar][]" placeholder="Name in Arabic">
								</div>
								<div class="col-12">
									<input type="email"  class="form-control" name="settings[members][email][]" placeholder="Email">
								</div>
							</div>
							<a href="javascript:;" class="delete-member" title="Delete record">
		                    	X
				    		</a>
						</div>`;
    </script>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Lenovo\Desktop\development\nama medical\laravel-api\resources\views/admin/settings/contact_us.blade.php ENDPATH**/ ?>