<?php $__env->startSection('title','Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<main class="content">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							Courses
						</h1>
						<div class="actions col-6">
							<a href="<?php echo e(route('add-course')); ?>"  class="btn btn-primary">Add New</a>
						</div>
					</div>
					<div class="card-body">
						<?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<form class="table-actions">
							<div class="left">
								<?php echo $__env->make('admin.components.rows_per_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</div>
							<div class="right">
								<?php echo $__env->make('admin.components.common_filters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      <th scope="col">ID</th>
							      <th scope="col">Image</th>
							      <th scope="col">Name (In English)</th>
							      <!-- <th scope="col">Name (In Arabic)</th> -->
							      <th scope="col">Status</th>
							      <th scope="col">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							    <tr>
							    	<td><?php echo e($record->id); ?></td>
							    	<td>
							    		<img class="banner-image" src="<?php echo e(asset('/admin/images/course_images/'.$record->image)); ?>">
							    	</td>
							    	<td><?php echo e($record->name_eng); ?></td>
							    	<!-- <td><?php echo e($record->name_ar); ?></td> -->
							    	<td>
							    		<select name="status" class="recordStatus" data-id="<?php echo e($record->id); ?>">
							    			<option value="">Change Status</option>
							    			<option value="1" <?php if($record->status==1): ?> selected <?php endif; ?>>Active</option>
							    			<option value="0" <?php if($record->status==0): ?> selected <?php endif; ?>>Deactive</option>
							    		</select>
							    	</td>
							    	<td>
							    		<a href="<?php echo e(route('edit-course',$record->id)); ?>" title="Edit record Details">
							    			<i class="align-middle me-2" data-feather="edit"></i>
							    		</a> 
							    		<a href="<?php echo e(route('view-course',$record->id)); ?>" title="View Record Details">
							    			<i class="align-middle me-2" data-feather="file"></i>
							    		</a> 
							    		<a href="<?php echo e(route('delete-course',$record->id)); ?>" title="Delete Record"  onclick="
							    		if(confirm('Are you sure to Delete Record?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						  	</tbody>
						</table>
						<div class="pagination">
							<?php echo e($records->links()); ?>

						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeCourseStatus'); ?>";
	</script>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Lenovo\Desktop\development\nama medical\laravel-api\resources\views/admin/courses/list.blade.php ENDPATH**/ ?>