<?php $__env->startSection('title','Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<main class="content admin-order-details">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View Order Details</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						<?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<div class="order-overview col-md-12">
							<div class="col-md-6 summary">
								<p>Summary</p>
								<ul>
									<li>
										<span>Order ID: </span> <?php echo e($record->id); ?>

									</li>
									<li>
										<span>Order Date: </span> <?php echo e($record->created_at); ?>

									</li>
									<li>
										<span>Order Total: </span> SAR <?php echo e($record->total); ?>

									</li>
									<li>
										<span>Payment Status: </span> <span class="status-<?php echo e($record->payment->status); ?>"><?php echo e($record->payment->status); ?></span>
									</li>
								</ul>
							</div>
							<div class="col-md-6 billing-details">
								<p>Billing Address</p>
								<ul>
									<li><?php echo e($usermeta['first_name']); ?> <?php echo e($usermeta['last_name']); ?></li>
									<li><?php echo e($usermeta['address_1']); ?></li>
									<li><?php echo e($usermeta['address_2']); ?></li>
									<li><?php echo e($usermeta['city']); ?>, <?php echo e($usermeta['state']); ?>, <?php echo e($usermeta['zipcode']); ?></li>
								</ul>
							</div>
						</div>
						<div class="col-md-12 items">
							<table class="table stripe-table">
								<tr>
									<th>Image</th>
									<th>Course</th>
									<th>Quantity</th>
									<th>Amount</th>
									<th>Total</th>
								</tr>
								<?php $__currentLoopData = $record->order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td>
										<img style="width: 100px;" src="<?php echo e(asset('admin/images/course_images/'.$item->course->image)); ?>" alt="<?php echo e($item->course->name_eng); ?>">
									</td>
									<td>
										<?php echo e($item->course->name_eng); ?>

									</td>
									<td>
										<?php echo e($item->qty); ?>

									</td>
									<td>
										<?php echo e($item->amount); ?>

									</td>
									<td>
										<?php echo e($item->total); ?>

									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td colspan="4" class="text-right">Sub Total</td>
									<td><?php echo e($record->sub_total); ?></td>
								</tr>
								<tr>
									<td colspan="4" class="text-right">Tax</td>
									<td><?php echo e($record->tax); ?></td>
								</tr>
								<tr>
									<td colspan="4" class="text-right">Total</td>
									<td><?php echo e($record->total); ?></td>
								</tr>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravel-api/resources/views/admin/orders/view.blade.php ENDPATH**/ ?>