<?php $__env->startSection('title','Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<main class="content admin-orders-listing">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							Orders
						</h1>
					</div>
					<div class="card-body">
						<?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<form class="table-actions">
							<div class="left">
								<?php echo $__env->make('admin.components.rows_per_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</div>
							<div class="right">
								<?php echo $__env->make('admin.components.common_filters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      <th scope="col">Order ID</th>
							      <th scope="col">User ID</th>
							      <th scope="col">Sub Total</th>
							      <th scope="col">Tax</th>
							      <th scope="col">Total</th>
							      <th scope="col">Status</th>
							      <th scope="col">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							    <tr>
							    	<td><?php echo e($record->id); ?></td>
							    	<td><a href="<?php echo e(route('view-user',$record->user_id)); ?>" target="_blank" title="View User Details"><?php echo e($record->user_id); ?></a></td>
							    	<td>SAR <?php echo e($record->sub_total); ?></td>
							    	<td>SAR <?php echo e($record->tax); ?></td>
							    	<td>SAR <?php echo e($record->total); ?></td>
							    	<td>
							    		<!-- <select name="status" class="recordStatus" data-id="<?php echo e($record->id); ?>">
							    			<option value="">Change Status</option>
							    			<option value="1" <?php if($record->status==1): ?> selected <?php endif; ?>>Active</option>
							    			<option value="0" <?php if($record->status==0): ?> selected <?php endif; ?>>Deactive</option>
							    		</select> -->
							    		<span class="status-<?php echo e($record->payment->status); ?>"><?php echo e($record->payment->status); ?></span>
							    	</td>
							    	<td>
							    		<a href="<?php echo e(route('admin.view_order',[ 'id'=>$record->id ])); ?>" title="View Record Details">
							    			<i class="align-middle me-2" data-feather="file"></i>
							    		</a> 
							    		<a href="" title="Delete Record"  onclick="
							    		if(confirm('Are you sure to Delete Record?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						  	</tbody>
						</table>
						<div class="pagination">
							<?php echo e($records->links()); ?>

						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeCourseStatus'); ?>";
	</script>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Lenovo\Desktop\development\nama medical\laravel-api\resources\views/admin/orders/list.blade.php ENDPATH**/ ?>