<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::prefix('admin')->group(function(){
    Route::get('/login','Auth\AdminLoginController@showLoginForm')->name('admin.login');
    Route::post('/login', 'Auth\AdminLoginController@login')->name('admin.login.submit');
    Route::get('logout/', 'Auth\AdminLoginController@logout')->name('admin.logout');
    Route::get('/dashboard', 'Auth\AdminController@index')->name('admin.dashboard');

    /*************** Users Routes starts here   ***************/

    Route::get('/list-users', 'Admin\UsersController@index')->name('admin.list_users');
    Route::post('/change-user-status', 'Admin\UsersController@changeUserStatus')->name('admin.changeUserStatus');
    Route::get('delete-user/{id}', 'Admin\UsersController@delete_user')->name('delete-user');
    Route::get('view-user/{id}', 'Admin\UsersController@view_user')->name('view-user');
    Route::get('add-user', 'Admin\UsersController@add_user')->name('add-user');
    Route::post('submit-new-user', 'Admin\UsersController@save_new_user')->name('submit-new-user');
    /*************** Users Routes ends here   ***************/

    /*************** Testimonials Routes starts here   ***************/

    Route::get('/list-testimonials', 'Admin\TestimonialsController@index')->name('admin.list_testimonials');
    Route::get('add-testimonial', 'Admin\TestimonialsController@add')->name('add-testimonial');
    Route::post('submit-new-testimonial', 'Admin\TestimonialsController@save_new_record')->name('submit-new-testimonial');
    Route::get('edit-testimonial/{id}', 'Admin\TestimonialsController@edit')->name('edit-testimonial');
    Route::post('submit-edit-testimonial', 'Admin\TestimonialsController@save_edit_record')->name('submit-edit-testimonial');
    Route::get('view-testimonial/{id}', 'Admin\TestimonialsController@view')->name('view-testimonial');
    Route::get('delete-testimonial/{id}', 'Admin\TestimonialsController@delete')->name('delete-testimonial');
    Route::post('/change-testimonial-status', 'Admin\TestimonialsController@changeStatus')->name('admin.changeTestimonialStatus');

    /*************** Testimonials Routes ends here   ***************/

    /*************** FAQ Routes starts here   ***************/

    Route::get('/list-faq', 'Admin\FaqController@index')->name('admin.list_faq');
    Route::get('add-faq', 'Admin\FaqController@add')->name('add-faq');
    Route::post('submit-new-faq', 'Admin\FaqController@save_new_record')->name('submit-new-faq');

    Route::get('edit-faq/{id}', 'Admin\FaqController@edit')->name('edit-faq');
    Route::post('submit-edit-faq', 'Admin\FaqController@save_edit_record')->name('submit-edit-faq');

    Route::get('view-faq/{id}', 'Admin\FaqController@view')->name('view-faq');
    Route::get('delete-faq/{id}', 'Admin\FaqController@delete')->name('delete-faq');
    Route::post('/change-faq-status', 'Admin\FaqController@changeStatus')->name('admin.changeFaqStatus');
    
    /*************** FAQ Routes ends here   ***************/

    /*************** Pages Management Routes starts here   ***************/

    Route::get('/list-pages', 'Admin\PagesController@index')->name('admin.list_pages');
    Route::get('add-page', 'Admin\PagesController@add')->name('add-page');
    Route::post('submit-new-page', 'Admin\PagesController@save_new_record')->name('submit-new-page');

    Route::get('edit-page/{id}', 'Admin\PagesController@edit')->name('edit-page');
    Route::post('submit-edit-page', 'Admin\PagesController@save_edit_record')->name('submit-edit-page');
    
    Route::get('view-page/{id}', 'Admin\PagesController@view')->name('view-page');
    Route::get('delete-page/{id}', 'Admin\PagesController@delete')->name('delete-page');
    Route::post('/change-page-status', 'Admin\PagesController@changeStatus')->name('admin.changePageStatus');
    
    /*************** Pages Management Routes ends here   ***************/

    /*************** Newsletter Routes starts here   ***************/

    Route::get('/list-subscribers', 'Admin\NewsletterController@subscribers')->name('admin.list_subscribers');
    Route::get('delete-subscriber/{id}', 'Admin\NewsletterController@delete')->name('delete-subscriber');

    Route::get('/send-newsletter', 'Admin\NewsletterController@send_newsletter_form')->name('admin.send-newsletter');
    Route::post('/submit-newsletter', 'Admin\NewsletterController@submit_newsletter')->name('admin.submit_newsletter');
    
    /*************** Newsletter Routes ends here   ***************/

    /*************** Banners Management starts here   ***************/

    Route::get('/list-banners/{type}', 'Admin\BannersController@index')->name('admin.list_banners');
    Route::post('/change-banner-status', 'Admin\BannersController@changeStatus')->name('admin.changeBannerStatus');

    Route::get('add-banner/{type}', 'Admin\BannersController@add')->name('add-banner');
    Route::post('submit-new-banner', 'Admin\BannersController@save_new_record')->name('submit-new-banner');

    Route::get('edit-banner/{id}', 'Admin\BannersController@edit')->name('edit-banner');
    Route::post('submit-edit-banner', 'Admin\BannersController@save_edit_record')->name('submit-edit-banner');
    
    Route::get('view-banner/{id}', 'Admin\BannersController@view')->name('view-banner');
    Route::get('delete-banner/{type}/{id}', 'Admin\BannersController@delete')->name('delete-banner');
    
    /*************** Banners Management ends here   ***************/

    /*************** Categories routes starts here   ***************/

    Route::get('/list-categories', 'Admin\CategoryController@index')->name('admin.list_categories');
    Route::post('/change-category-status', 'Admin\CategoryController@changeStatus')->name('admin.changeCategoryStatus');

    Route::get('add-category', 'Admin\CategoryController@add')->name('add-category');
    Route::post('submit-new-category', 'Admin\CategoryController@save_new_record')->name('submit-new-category');

    Route::get('view-category/{id}', 'Admin\CategoryController@view')->name('view-category');
    Route::get('delete-category/{id}', 'Admin\CategoryController@delete')->name('delete-category');

    Route::get('edit-category/{id}', 'Admin\CategoryController@edit')->name('edit-category');
    Route::post('submit-edit-category', 'Admin\CategoryController@save_edit_record')->name('submit-edit-category');
    
    /*************** Categories routes ends here   ***************/

    /*************** Courses routes starts here   ***************/

    Route::get('/list-courses', 'Admin\CourseController@index')->name('admin.list_courses');
    Route::post('/change-course-status', 'Admin\CourseController@changeStatus')->name('admin.changeCourseStatus');

    Route::get('add-course', 'Admin\CourseController@add')->name('add-course');
    Route::post('submit-new-course', 'Admin\CourseController@save_new_record')->name('submit-new-course');
    
    Route::get('view-course/{id}', 'Admin\CourseController@view')->name('view-course');
    Route::get('delete-course/{id}', 'Admin\CourseController@delete')->name('delete-course');

    Route::get('edit-course/{id}', 'Admin\CourseController@edit')->name('edit-course');
    Route::post('submit-edit-course', 'Admin\CourseController@save_edit_record')->name('submit-edit-course');
    
    
    /*************** Courses routes ends here   ***************/

    /*************** News routes starts here   ***************/

    Route::get('/list-news', 'Admin\NewsController@index')->name('admin.list_news');
    Route::post('/change-news-status', 'Admin\NewsController@changeStatus')->name('admin.changeNewsStatus');

    Route::get('add-news', 'Admin\NewsController@add')->name('add-news');
    Route::post('submit-new-news', 'Admin\NewsController@save_new_record')->name('submit-new-news');

    Route::get('view-news/{id}', 'Admin\NewsController@view')->name('view-news');
    Route::get('delete-news/{id}', 'Admin\NewsController@delete')->name('delete-news');

    Route::get('edit-news/{id}', 'Admin\NewsController@edit')->name('edit-news');
    Route::post('submit-edit-news', 'Admin\NewsController@save_edit_record')->name('submit-edit-news');
    
    
    /*************** News routes ends here   ***************/

    /*************** Orders routes starts here   ***************/

    Route::get('/list-orders', 'Admin\OrdersController@index')->name('admin.list_orders');
    Route::get('/view-order/{id}', 'Admin\OrdersController@view_order_details')->name('admin.view_order');

    /*************** Orders routes ends here   ***************/

    /*************** Settings starts here   ***************/

    Route::get('/contact-settings', 'Admin\SettingsController@contact_settings')->name('admin.contact_settings');
    Route::post('/save-contact-settings','Admin\SettingsController@save_contact_settings')->name('save-contact-settings');

    Route::get('/global-settings', 'Admin\SettingsController@global_settings')->name('admin.global_settings');
    Route::post('/save-global-settings','Admin\SettingsController@save_global_settings')->name('save-global-settings');

    /*************** Settings ends here   ***************/
});

Route::get('/home', 'HomeController@index')->name('home');
Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

// Localization
Route::get('/js/lang.js', function () {
    $strings = Cache::rememberForever('lang.js', function () {
        $lang = config('app.locale');

        $files   = glob(resource_path('lang/' . $lang . '/*.php'));
        $strings = [];

        foreach ($files as $file) {
            $name           = basename($file, '.php');
            $strings[$name] = require $file;
        }

        return $strings;
    });

    header('Content-Type: text/javascript');
    echo('window.i18n = ' . json_encode($strings) . ';');
    exit();
})->name('assets.lang');
