<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('register','Api\UserController@register');
Route::post('login','Api\UserController@login');
Route::post('google-login','Api\UserController@google_login');

Route::post('forget-password','Api\UserController@forget_password');
Route::post('reset-password', 'Api\UserController@reset_password');

Route::get('profile','Api\UserController@getAuthenticatedUser');
Route::post('edit-profile','Api\UserController@edit_profile');

/************************************************************/
Route::middleware(['cors'])->group(function () {
    Route::post('get-meta-information','Api\CommonController@get_meta_information');

    Route::post('email_subscribe','Api\CommonController@subscribe');
    Route::post('banner-images','Api\CommonController@get_banner_images');
    Route::post('book-demo','Api\CommonController@book_demo');
    Route::post('contact','Api\CommonController@contact');
    Route::post('course-register','Api\CommonController@course_register');
});
/************************************************************/
Route::post('static-pages','Api\PagesController@get_page');
Route::post('contact-settings','Api\PagesController@contact_settings');
Route::post('faq','Api\PagesController@faq');

/************************************************************/

Route::post('news-insights','Api\NewsController@listing');
Route::post('news-insights-details','Api\NewsController@news_details');
Route::post('latest-news','Api\NewsController@latest_news');
Route::post('popular-news','Api\NewsController@popular_news');

/************************************************************/

Route::post('courses','Api\CourseController@listing');
Route::post('course-details','Api\CourseController@course_details');
Route::post('popular-courses','Api\CourseController@popular_courses');
Route::post('courses-by-category','Api\CourseController@get_courses_by_category');
Route::post('get-course-qty','Api\CourseController@get_course_qty');
Route::post('check-course-booking','Api\CourseController@check_course_booking');


/************************************************************/

Route::post('cart-items','Api\CartController@get_cart_items');
Route::post('get-tax-percentage','Api\CartController@get_tax_percentage');

Route::post('validate-billing-address','Api\CheckoutController@validate_billing_address');
Route::post('process-payment','Api\CheckoutController@process_payment');
Route::post('update-payment-status','Api\CheckoutController@update_payment_status');

/****************************************************************************/
Route::post('orders','Api\CourseController@orders');
Route::post('order_details','Api\CourseController@order_details');

/****************************************************************************/

Route::post('search','Api\CourseController@search');

// Route::get('test', [TestController::class, 'index']);

Route::middleware('auth:api')->get('/user', function(Request $request){
    return $request->user();
});