@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      	<td>ID</td>
							      	<td>{{$user->id}}</td>
							    </tr>
							    <tr>
							      	<td>Status</td>
							      	<td>@if($user->status==1) Active @else Deactive @endif</td>
							    </tr>
							    <tr>
							      	<td>Name</td>
							      	<td>{{$user->name}}</td>
							    </tr>
							    <tr>
							      	<td>Email</td>
							      	<td>{{$user->email}}</td>
							    </tr>
							    <tr>
							      	<td>Contact</td>
							      	<td>{{$user->contact_number}}</td>
							    </tr>
							    
							    <tr>
							      	<td>SCFHS number</td>
							      	<td>{{$user->scfhs_number}}</td>
							    </tr>
							    <tr>
							      	<td>Workplace</td>
							      	<td>{{$user->workplace}}</td>
							    </tr>
							    <tr>
							      	<td>Profession</td>
							      	<td>{{$user->profession}}</td>
							    </tr>
							    <tr>
							      	<td>Created at</td>
							      	<td>{{\Carbon\Carbon::parse($user->created_at)->format('d-m-Y')}}</td>
							    </tr>
							    <tr>
							      	<td colspan="2">
							      		<a href="{{ route('admin.list_users') }}" class="btn btn-primary">Back</a>
							      	</td>
							    </tr>
						  	</thead>
						  	<tbody>
							    
						  	</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
