@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							Users
						</h1>
						<div class="actions col-6">
							<a href="{{ route('add-user') }}"  class="btn btn-primary">Add New</a>
						</div>
					</div>
					<div class="card-body">
						@include('flash-message')
						<form class="table-actions">
							<div class="left">
								@include('admin.components.rows_per_page')
							</div>
							<div class="right">
								@include('admin.components.common_filters')
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      <th scope="col">ID</th>
							      <th scope="col">Name</th>
							      <th scope="col">Email</th>
							      <th scope="col">Contact</th>
							      <th scope="col">Status</th>
							      <th scope="col">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    @foreach($allUsers as $user)
							    <tr>
							    	<td>{{$user->id}}</td>
							    	<td>{{$user->name}}</td>
							    	<td>{{$user->email}}</td>
							    	<td>{{$user->contact_number}}</td>
							    	<td>
							    		<select name="status" class="recordStatus" data-id="{{$user->id}}">
							    			<option value="">Change Status</option>
							    			<option value="1" @if($user->status==1) selected @endif>Active</option>
							    			<option value="0" @if($user->status==0) selected @endif>Deactive</option>
							    		</select>
							    	</td>
							    	<td>
							    		<a href="{{ route('view-user',$user->id) }}" title="View User Details">
							    			<i class="align-middle me-2" data-feather="file"></i>
							    		</a> 
							    		<a href="{{ route('delete-user',$user->id) }}" title="Delete User"  onclick="
							    		if(confirm('Are you sure to Delete User?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    @endforeach
						  	</tbody>
						</table>
						<div class="pagination">
							{{ $allUsers->links() }}
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeUserStatus'); ?>";
	</script>
</main>
@endsection
