@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add User</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-user') }}">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Name</label>
								<div class="col-8">
									<input type="text" class="form-control" name="name" value="{{old('name')}}">
									@if($errors->has('name'))
			                			@component('components.error')
			                				{{$errors->first('name')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Email</label>
								<div class="col-8">
									<input type="email" class="form-control" name="email" value="{{ old('email') }}">
									@if($errors->has('email'))
			                			@component('components.error')
			                				{{$errors->first('email')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Password</label>
								<div class="col-8">
									<input type="password" class="form-control" name="password" >
									@if($errors->has('password'))
			                			@component('components.error')
			                				{{$errors->first('password')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Confirm Password</label>
								<div class="col-8">
									<input type="password" class="form-control" name="password_confirmation" >
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Address</label>
								<div class="col-8">
									<textarea class="form-control" name="address" >{{ old('address') }}</textarea>
									@if($errors->has('address'))
			                			@component('components.error')
			                				{{$errors->first('address')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Contact Number</label>
								<div class="col-8">
									<input type="text" class="form-control" name="contact_number"  value="{{ old('contact_number') }}">
									@if($errors->has('contact_number'))
			                			@component('components.error')
			                				{{$errors->first('contact_number')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">SCFHS No</label>
								<div class="col-8">
									<input type="text" class="form-control" name="scfhs_number"  value="{{ old('scfhs_number') }}">
									@if($errors->has('scfhs_number'))
			                			@component('components.error')
			                				{{$errors->first('scfhs_number')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Workplace</label>
								<div class="col-8">
									<input type="text" class="form-control" name="workplace"  value="{{ old('workplace') }}">
									@if($errors->has('workplace'))
			                			@component('components.error')
			                				{{$errors->first('workplace')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Profession</label>
								<div class="col-8">
									<select name="profession" id="profession-input" class="form-control">
										<option value="Profession 1" @if(old("profession") === "Profession 1") selected @endif>Profession 1</option>
										<option value="Profession 2"  @if(old("profession") === "Profession 2") selected @endif>Profession 2</option>
										<option value="Profession 3"  @if(old("profession") === "Profession 3") selected @endif>Profession 3</option>
									</select>
									@if($errors->has('profession'))
			                			@component('components.error')
			                				{{$errors->first('profession')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
