@extends('layouts.admin_app')

@section('title','Add Testimonial - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add Testimonial</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-testimonial') }}">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Name</label>
								<div class="col-8">
									<input type="text" class="form-control" name="name" value="{{old('name')}}">
									@if($errors->has('name'))
			                			@component('components.error')
			                				{{$errors->first('name')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Email</label>
								<div class="col-8">
									<input type="email" class="form-control" name="email" value="{{ old('email') }}">
									@if($errors->has('email'))
			                			@component('components.error')
			                				{{$errors->first('email')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Heading ( In English )</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading_eng" value="{{ old('heading_eng') }}">
									@if($errors->has('heading_eng'))
			                			@component('components.error')
			                				{{$errors->first('heading_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Description ( In English )</label>
								<div class="col-8">
									<textarea class="editor" class="form-control" name="description_eng">{{ old('description_eng') }}</textarea>
									@if($errors->has('description_eng'))
			                			@component('components.error')
			                				{{$errors->first('description_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Heading ( In Arabic )</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading_ar" value="{{ old('heading_ar') }}">
									@if($errors->has('heading_ar'))
			                			@component('components.error')
			                				{{$errors->first('heading_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Description ( In Arabic )</label>
								<div class="col-8">
									<textarea class="editor" class="form-control" name="description_ar">{{ old('description_ar') }}</textarea>
									@if($errors->has('description_ar'))
			                			@component('components.error')
			                				{{$errors->first('description_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
