@extends('layouts.admin_app')

@section('title','Add Page - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add Page</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-page') }}">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Heading</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading_eng" value="{{ old('heading_eng') }}">
									@if($errors->has('heading_eng'))
			                			@component('components.error')
			                				{{$errors->first('heading_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Description </label>
								<div class="col-8">
									<textarea class="form-control editor" name="description_eng">{{ old('description_eng') }}</textarea>
									@if($errors->has('description_eng'))
			                			@component('components.error')
			                				{{$errors->first('description_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							
							<hr>
							<h3 class="mb-5">Meta Information</h3>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Meta Title</label>
								<div class="col-8">
									<input type="text" class="form-control" name="meta_title" value="{{ old('meta_title') }}">
									@if($errors->has('meta_title'))
			                			@component('components.error')
			                				{{$errors->first('meta_title')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Meta Description</label>
								<div class="col-8">
									<textarea class="form-control" name="meta_description">{{ old('meta_description') }}</textarea>
									@if($errors->has('meta_description'))
			                			@component('components.error')
			                				{{$errors->first('meta_description')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4" >
								<label class="col-3" for="">
									Meta Keywords
								</label>
								<div class="col-8">
									<input type="text" class="form-control" name="meta_keywords" value="{{ old('meta_keywords') }}">
									@if($errors->has('meta_keywords'))
			                			@component('components.error')
			                				{{$errors->first('meta_keywords')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/full/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
