@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content admin-order-details">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View Order Details</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<div class="order-overview col-md-12">
							<div class="col-md-6 summary">
								<p>Summary</p>
								<ul>
									<li>
										<span>Order ID: </span> {{$record->id}}
									</li>
									<li>
										<span>Order Date: </span> {{$record->created_at}}
									</li>
									<li>
										<span>Order Total: </span> SAR {{$record->total}}
									</li>
									<li>
										<span>Payment Status: </span> <span class="status-{{$record->payment->status}}">{{$record->payment->status}}</span>
									</li>
								</ul>
							</div>
						</div>
						@if(!empty($record->course))
						<div class="col-md-12 items">
							<table class="table stripe-table">
								<tr>
									<th>Image</th>
									<th>Course</th>
									<th>Amount</th>
									<th>Tax</th>
									<th>Total</th>
								</tr>
								<tr>
									<td>
										<img style="width: 100px;" src="{{ asset('admin/images/course_images/'.$record->course->image) }}" alt="{{$record->course->name_eng}}">
									</td>
									<td>
										{{$record->course->name_eng}}
									</td>
									<td>
										SAR {{$record->sub_total}}
									</td>
									<td>
										SAR {{$record->tax}}
									</td>
									<td>
										SAR {{$record->total}}
									</td>
								</tr>
							</table>
						</div>
						@else
						<div class="col-md-12 items">
							<p style="text-align: center;">Course doesn't exists.</p>
						</div>
						@endif
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
