@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content admin-orders-listing">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							Orders
						</h1>
					</div>
					<div class="card-body">
						@include('flash-message')
						<form class="table-actions">
							<div class="left">
								@include('admin.components.rows_per_page')
							</div>
							<div class="right">
								@include('admin.components.common_filters')
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      <th scope="col">Order ID</th>
							      <th scope="col">User ID</th>
							      <th scope="col">Sub Total</th>
							      <th scope="col">Tax</th>
							      <th scope="col">Total</th>
							      <th scope="col">Status</th>
							      <th scope="col">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    @foreach($records as $record)
							    <tr>
							    	<td>{{$record->id}}</td>
							    	<td><a href="{{ route('view-user',$record->user_id) }}" target="_blank" title="View User Details">{{$record->user_id}}</a></td>
							    	<td>SAR {{$record->sub_total}}</td>
							    	<td>SAR {{$record->tax}}</td>
							    	<td>SAR {{$record->total}}</td>
							    	<td>
							    		<!-- <select name="status" class="recordStatus" data-id="{{$record->id}}">
							    			<option value="">Change Status</option>
							    			<option value="1" @if($record->status==1) selected @endif>Active</option>
							    			<option value="0" @if($record->status==0) selected @endif>Deactive</option>
							    		</select> -->
							    		<span class="status-{{$record->payment->status}}">{{$record->payment->status}}</span>
							    	</td>
							    	<td>
							    		<a href="{{ route('admin.view_order',[ 'id'=>$record->id ]) }}" title="View Record Details">
							    			<i class="align-middle me-2" data-feather="file"></i>
							    		</a> 
							    		<a href="" title="Delete Record"  onclick="
							    		if(confirm('Are you sure to Delete Record?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    @endforeach
						  	</tbody>
						</table>
						<div class="pagination">
							{{ $records->links() }}
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeCourseStatus'); ?>";
	</script>
</main>
@endsection
