@extends('layouts.admin_app')

@section('title','Send Newsletter - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Send Newsletter</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('admin.submit_newsletter') }}">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4 users-list-wrap">
								<label class="col-3" for="">Select Users</label>
								<div class="col-8">
									<div class="users-list">
										<ul>
											@foreach ($users as $user)
											<li>
												<input type="checkbox" id="user-{{ $user->id }}" name="users[]" value="{{ $user->id }}"  {{ in_array($user->id, old('users', [])) ? 'checked' : '' }}>
												<label class="user-name" for="user-{{ $user->id }}">{{ $user->name }}</label>
											</li>
											@endforeach
										</ul>
									</div>
									@if($errors->has('users'))
			                			@component('components.error')
			                				{{$errors->first('users')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Subject</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading" value="{{ old('heading') }}">
									@if($errors->has('heading'))
			                			@component('components.error')
			                				{{$errors->first('heading')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Message</label>
								<div class="col-8">
									<textarea class="form-control editor" name="description">{{ old('description') }}</textarea>
									@if($errors->has('description'))
			                			@component('components.error')
			                				{{$errors->first('description')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
									<input type="button" name="Preview" id="preview-Newsletter" value="Preview" class="btn btn-secondary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- The Modal -->
  	<div class="modal" id="preview-Newsletter-Modal">
	    <div class="modal-dialog">
	      	<div class="modal-content">
		        <!-- Modal Header -->
		        <div class="modal-header">
		          	<h4 class="modal-title">Email Preview</h4>
		          	<button type="button" class="close" data-dismiss="modal">&times;</button>
		        </div>
		        <!-- Modal body -->
		        <div class="modal-body">
		          	<div>
		          		<h5 class="mail-title"></h5>
		          		<div class="mail-description"></div>
		          	</div>
		        </div>
		        <!-- Modal footer -->
		        <div class="modal-footer">
		          	<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
		        </div>
	      	</div>
	    </div>
  	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
