@extends('layouts.admin_app')

@section('title',"Newsletter Subscribers - Admin Dashboard")

@section('content')
<main class="content">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							Newsletter Subscribers
						</h1>
						<div class="actions col-6">
							
						</div>
					</div>
					<div class="card-body">
						@include('flash-message')
						<form class="table-actions">
							<div class="left">
								@include('admin.components.rows_per_page')
							</div>
							<div class="right">
								<div class="search">
									<input type="text" name="search" placeholder="Search" value="{{$search}}">
									<i class="align-middle me-2" data-feather="search"></i>
								</div>
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      	<th scope="col">ID</th>
							      	<th scope="col">Email</th>
							      	<th scope="col" style="width: 95px;">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    @foreach($records as $record)
							    <tr>
							    	<td>{{$record->id}}</td>
							    	<td>{{$record->email}}</td>
							    	
							    	<td>
							    		<a href="{{ route('delete-subscriber',$record->id) }}" title="Delete record"  onclick="
							    		if(confirm('Are you sure to Delete this?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    @endforeach
						  	</tbody>
						</table>
						<div class="pagination">
							{{ $records->links() }}
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeFaqStatus'); ?>";
	</script>
</main>
@endsection
