@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<table class="table table-striped view-table">
						  	<tr>
						      	<td>ID</td>
						      	<td>{{$record->id}}</td>
						    </tr>
						    <tr>
						      	<td>Status</td>
						      	<td>@if($record->status==1) Active @else Deactive @endif</td>
						    </tr>
						    <tr>
						      	<td>Title (In English)</td>
						      	<td>{{$record->title_eng}}</td>
						    </tr>
						    <tr>
						      	<td>Title (In Arabic)</td>
						      	<td>{{$record->title_ar}}</td>
						    </tr>
						    <tr>
						      	<td>Description (In English)</td>
						      	<td>{!! $record->description_eng !!}</td>
						    </tr>
						    <tr>
						      	<td>Description (In Arabic)</td>
						      	<td>{!! $record->description_ar !!}</td>
						    </tr>
						    @if($record->image)
						    <tr>
						    	<td>Image</td>
						    	<td>
						    		<img src="{{ asset('/admin/images/news_images/'.$record->image) }}" alt="{{$record->title_eng}}" style="height:150px;">
						    	</td>
						    </tr>
						    @endif
						    <tr>
						    	<td>Link</td>
						    	<td>
						    		<a href="{{ $record->link }}" target="_blank">View Link</a>
						    	</td>
						    </tr>
						    <tr>
						      	<td>Created at</td>
						      	<td>{{\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')}}</td>
						    </tr>
						    <tr>
						      	<td colspan="2">
						      		<a href="{{ route('admin.list_news') }}" class="btn btn-primary">Back</a>
						      	</td>
						    </tr>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
