@extends('layouts.admin_app')

@section('title',"News & Insights - Admin Dashboard")

@section('content')
<main class="content">
	<div class="container-fluid p-0">

		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h1 class="h3 mb-3 col-6">
							News & Insights
						</h1>
						<div class="actions col-6">
							<a href="{{ route('add-news') }}"  class="btn btn-primary">Add New</a>
						</div>
					</div>
					<div class="card-body">
						@include('flash-message')
						<form class="table-actions">
							<div class="left">
								@include('admin.components.rows_per_page')
							</div>
							<div class="right">
								@include('admin.components.common_filters')
							</div>
						</form>
						<table class="table table-striped">
						  	<thead>
							    <tr>
							      	<th scope="col">ID</th>
							      	<th scope="col">Title (In English)</th>
							      	<th scope="col">Title (In Arabic)</th>
							      	<th scope="col">Status</th>
							      	<th scope="col" style="width: 90px;">Actions</th>
							    </tr>
						  	</thead>
						  	<tbody>
							    @foreach($records as $record)
							    <tr>
							    	<td>{{$record->id}}</td>
							    	<td>{{$record->title_eng}}</td>
							    	<td>{{$record->title_ar}}</td>
							    	<td>
							    		<select name="status" class="recordStatus" data-id="{{$record->id}}">
							    			<option value="">Change Status</option>
							    			<option value="1" @if($record->status==1) selected @endif>Active</option>
							    			<option value="0" @if($record->status==0) selected @endif>Deactive</option>
							    		</select>
							    	</td>
							    	<td>
							    		<a href="{{ route('edit-news',$record->id) }}" title="Edit record Details">
							    			<i class="align-middle me-2" data-feather="edit"></i>
							    		</a> 
							    		<a href="{{ route('view-news',$record->id) }}" title="View record Details">
							    			<i class="align-middle me-2" data-feather="file"></i>
							    		</a> 
							    		<a href="{{ route('delete-news',$record->id) }}" title="Delete record"  onclick="
							    		if(confirm('Are you sure to Delete this?')){
						                    return true;
					                    }
					                    else{
					                        event.preventDefault();return false;
					                    } ">
							    			<i class="align-middle me-2" data-feather="trash-2"></i>
							    		</a>
							    	</td>
							    </tr>
							    @endforeach
						  	</tbody>
						</table>
						<div class="pagination">
							{{ $records->links() }}
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		var change_status_url = "<?php echo route('admin.changeNewsStatus'); ?>";
	</script>
</main>
@endsection
