@extends('layouts.admin_app')

@section('title','Add FAQ - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add FAQ</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-faq') }}">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Heading (In English)</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading_eng" value="{{ old('heading_eng') }}">
									@if($errors->has('heading_eng'))
			                			@component('components.error')
			                				{{$errors->first('heading_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Description (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="description_eng">{{ old('description_eng') }}</textarea>
									@if($errors->has('description_eng'))
			                			@component('components.error')
			                				{{$errors->first('description_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Heading (In Arabic)</label>
								<div class="col-8">
									<input type="text" class="form-control" name="heading_ar" value="{{ old('heading_ar') }}">
									@if($errors->has('heading_ar'))
			                			@component('components.error')
			                				{{$errors->first('heading_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Description (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="description_ar">{{ old('description_ar') }}</textarea>
									@if($errors->has('description_ar'))
			                			@component('components.error')
			                				{{$errors->first('description_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
