@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<table class="table table-striped view-table">
						  	<thead>
							    <tr>
							      	<td>ID</td>
							      	<td>{{$record->id}}</td>
							    </tr>
							    <tr>
							      	<td>Status</td>
							      	<td>@if($record->status==1) Active @else Deactive @endif</td>
							    </tr>
							    <tr>
							      	<td>Name (In English)</td>
							      	<td>{{$record->name_eng}}</td>
							    </tr>
							    <tr>
							      	<td>Name (In Arabic)</td>
							      	<td>{{$record->name_ar}}</td>
							    </tr>
							    @if($record->categories[0]->id)
							    <tr>
							    	<td>Category</td>
							    	<td>{{$record->categories[0]->name_eng}}</td>
							    </tr>
							    @endif
							    <tr>
							      	<td>Image</td>
							      	<td>
							    		<img class="banner-image" src="{{ asset('/admin/images/course_images/'.$record->image) }}">
							    	</td>
							    </tr>
							    <tr>
							      	<td>Venue (In English)</td>
							      	<td>{{$record->venue_eng}}</td>
							    </tr>
							    <tr>
							      	<td>Venue (In Arabic)</td>
							      	<td>{{$record->venue_ar}}</td>
							    </tr>
							    
							    <tr>
							      	<td>Start Date</td>
							      	<td>{{$record->start_date}}</td>
							    </tr>
							    <tr>
							      	<td>End Date</td>
							      	<td>{{$record->end_date}}</td>
							    </tr>
							    <tr>
							      	<td>Course Price</td>
							      	<td>{{$record->amount}}</td>
							    </tr>
							    <tr>
							      	<td>Days</td>
							      	<td>{{$record->days}}</td>
							    </tr>
							    <tr>
							      	<td>Hours</td>
							      	<td>{{$record->hours}}</td>
							    </tr>
							    <tr>
							      	<td>About the Course (In English)</td>
							      	<td>{!! $record->about_course_eng !!}</td>
							    </tr>
							    <tr>
							      	<td>About the Course (In Arabic)</td>
							      	<td>{!! $record->about_course_ar !!}</td>
							    </tr>
							    <tr>
							      	<td>Prerequisites (In English)</td>
							      	<td>{!! $record->prerequisites_eng !!}</td>
							    </tr>
							    <tr>
							      	<td>Prerequisites (In Arabic)</td>
							      	<td>{!! $record->prerequisites_ar !!}</td>
							    </tr>
							    <tr>
							      	<td>Package Includes (In English)</td>
							      	<td>{!! $record->package_includes_eng !!}</td>
							    </tr>
							    <tr>
							      	<td>Package Includes (In Arabic)</td>
							      	<td>{!! $record->package_includes_ar !!}</td>
							    </tr>
							    <tr>
							      	<td>Created at</td>
							      	<td>{{\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')}}</td>
							    </tr>
							    @if($record->meta_title)
							    <tr>
							      	<td>Meta Title</td>
							      	<td>{!! $record->meta_title !!}</td>
							    </tr>
							    @endif
							    @if($record->meta_description)
							    <tr>
							      	<td>Meta Description</td>
							      	<td>{!! $record->meta_description !!}</td>
							    </tr>
							    @endif
							    @if($record->meta_keywords)
							    <tr>
							      	<td>Meta Keywords</td>
							      	<td>{!! $record->meta_keywords !!}</td>
							    </tr>
							    @endif
							    <tr>
							      	<td colspan="2">
							      		<a href="{{ route('admin.list_courses') }}" class="btn btn-primary">Back</a>
							      	</td>
							    </tr>
						  	</thead>
						  	<tbody>
							    
						  	</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
