@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')

<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add Course</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-course') }}" enctype="multipart/form-data">
							{{@csrf_field()}}
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Course Name (In English) </label>
								<div class="col-8">
									<input type="text" class="form-control" name="name_eng" value="{{old('name_eng')}}">
									@if($errors->has('name_eng'))
			                			@component('components.error')
			                				{{$errors->first('name_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Course Name (In Arabic) </label>
								<div class="col-8">
									<input type="text" class="form-control" name="name_ar" value="{{old('name_ar')}}">
									@if($errors->has('name_ar'))
			                			@component('components.error')
			                				{{$errors->first('name_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="category">Category</label>
								<div class="col-8">
									<select name="category" id="category" class="form-control">
										<option value="">Select Category</option>
										@foreach($categories as $cat)
										<option value="{{$cat->id}}">{{$cat->name_eng}}</option>
										@endforeach
									</select>
									@if($errors->has('category'))
			                			@component('components.error')
			                				{{$errors->first('category')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Image</label>
								<div class="col-8">
									<input type="file" class="form-control input-image-upload" name="image" >
									<div class="preview-image" style="display: none;"></div>
									@if($errors->has('image'))
			                			@component('components.error')
			                				{{$errors->first('image')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Venue (In English) </label>
								<div class="col-8">
									<input type="text" class="form-control" name="venue_eng" value="{{old('venue_eng')}}">
									@if($errors->has('venue_eng'))
			                			@component('components.error')
			                				{{$errors->first('venue_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Venue (In Arabic) </label>
								<div class="col-8">
									<input type="text" class="form-control" name="venue_ar" value="{{old('venue_ar')}}">
									@if($errors->has('venue_ar'))
			                			@component('components.error')
			                				{{$errors->first('venue_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Start Date </label>
								<div class="col-8">
									<input type="text" class="form-control start_date" name="start_date" value="{{old('start_date')}}" readonly>
									@if($errors->has('start_date'))
			                			@component('components.error')
			                				{{$errors->first('start_date')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">End Date </label>
								<div class="col-8">
									<input type="text" class="form-control end_date" name="end_date" value="{{old('end_date')}}" readonly>
									@if($errors->has('end_date'))
			                			@component('components.error')
			                				{{$errors->first('end_date')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Course Price </label>
								<div class="col-8">
									<input type="text" class="form-control" name="amount" value="{{old('amount')}}">
									@if($errors->has('amount'))
			                			@component('components.error')
			                				{{$errors->first('amount')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Number of Days </label>
								<div class="col-8">
									<input type="text" class="form-control" name="days" value="{{old('days')}}">
									@if($errors->has('days'))
			                			@component('components.error')
			                				{{$errors->first('days')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Hours </label>
								<div class="col-8">
									<input type="text" class="form-control" name="hours" value="{{old('hours')}}">
									@if($errors->has('hours'))
			                			@component('components.error')
			                				{{$errors->first('hours')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Number of seats </label>
								<div class="col-8">
									<input type="number" class="form-control" name="qty" value="{{old('qty')}}">
									@if($errors->has('qty'))
			                			@component('components.error')
			                				{{$errors->first('qty')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">About the Course (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="about_course_eng">{{ old('about_course_eng') }}</textarea>
									@if($errors->has('about_course_eng'))
			                			@component('components.error')
			                				{{$errors->first('about_course_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">About the Course (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="about_course_ar">{{ old('about_course_ar') }}</textarea>
									@if($errors->has('about_course_ar'))
			                			@component('components.error')
			                				{{$errors->first('about_course_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Prerequisites (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="prerequisites_eng">{{ old('prerequisites_eng') }}</textarea>
									@if($errors->has('prerequisites_eng'))
			                			@component('components.error')
			                				{{$errors->first('prerequisites_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Prerequisites (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="prerequisites_ar">{{ old('prerequisites_ar') }}</textarea>
									@if($errors->has('prerequisites_ar'))
			                			@component('components.error')
			                				{{$errors->first('prerequisites_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Package includes (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="package_includes_eng">{{ old('package_includes_eng') }}</textarea>
									@if($errors->has('package_includes_eng'))
			                			@component('components.error')
			                				{{$errors->first('package_includes_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Package includes (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="package_includes_ar">{{ old('package_includes_ar') }}</textarea>
									@if($errors->has('package_includes_ar'))
			                			@component('components.error')
			                				{{$errors->first('package_includes_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Speakers</label>
								<div class="col-8">
									<textarea class="form-control editor" name="speakers">{{ old('speakers') }}</textarea>
									@if($errors->has('speakers'))
			                			@component('components.error')
			                				{{$errors->first('speakers')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Curriculum</label>
								<div class="col-8">
									<textarea class="form-control editor" name="curriculum">{{ old('curriculum') }}</textarea>
									@if($errors->has('curriculum'))
			                			@component('components.error')
			                				{{$errors->first('curriculum')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<hr>
							<h3 class="mb-5">Meta Information</h3>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Meta Title</label>
								<div class="col-8">
									<input type="text" class="form-control" name="meta_title" value="{{ old('meta_title') }}">
									@if($errors->has('meta_title'))
			                			@component('components.error')
			                				{{$errors->first('meta_title')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Meta Description</label>
								<div class="col-8">
									<textarea class="form-control" name="meta_description">{{ old('meta_description') }}</textarea>
									@if($errors->has('meta_description'))
			                			@component('components.error')
			                				{{$errors->first('meta_description')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4" >
								<label class="col-3" for="">
									Meta Keywords
								</label>
								<div class="col-8">
									<input type="text" class="form-control" name="meta_keywords" value="{{ old('meta_keywords') }}">
									@if($errors->has('meta_keywords'))
			                			@component('components.error')
			                				{{$errors->first('meta_keywords')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
