@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<table class="table table-striped view-table">
						    <tr>
						      	<td>Status</td>
						      	<td>@if($record->status==1) Active @else Deactive @endif</td>
						    </tr>
						    <tr>
						    	<td>Image</td>
						    	<td>
						    		@if($record->image)
						    		<img class="banner-image" src="{{ asset('/admin/images/category_images/'.$record->image) }}">
						    		@endif
						    	</td>
						    </tr>
						    @if($record->parent_category)
						    <tr>
						    	<td>Parent</td>
						    	<td>{{ $record->parent_category->name_eng }}</td>
						    </tr>
						    @endif
						    <tr>
						      	<td>Name (In English)</td>
						      	<td>{!! $record->name_eng !!}</td>
						    </tr>
						    <tr>
						      	<td>Name (In Arabic)</td>
						      	<td>{!! $record->name_ar !!}</td>
						    </tr>
						    <tr>
						      	<td>Created at</td>
						      	<td>{{\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')}}</td>
						    </tr>
						    <tr>
						      	<td colspan="2">
						      		<a href="{{ route('admin.list_categories') }}" class="btn btn-primary">Back</a>
						      	</td>
						    </tr>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
