@extends('layouts.admin_app')

@section('title','Edit Category - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Edit Category</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-edit-category') }}" enctype="multipart/form-data">
							{{@csrf_field()}}
							<input type="hidden" name="id" value="{{ $record->id }}">
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Parent</label>
								<div class="col-8">
									<select name="parent" id="">
										<option value="">Select Parent Category</option>
										{!! $categoriesDropdown !!}
									</select>
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Category Image</label>
								<div class="col-8">
									<input type="file" class="form-control input-image-upload" name="image" >
									<div class="preview-image" @if(!$record->image) style="display: none;" @endif>
										
										<img src="{{ asset('/admin/images/category_images/'.$record->image) }}" alt="">
										
									</div>
									<input type="hidden" name="old_image" value="{{ $record->image }}">
									@if($errors->has('image'))
			                			@component('components.error')
			                				{{$errors->first('image')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Category Name (In English)</label>
								<div class="col-8">
									<input type="text" class="form-control editor" name="name_eng" value="{{ $record->name_eng }}">
									@if($errors->has('name_eng'))
			                			@component('components.error')
			                				{{$errors->first('name_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Category Name (In Arabic)</label>
								<div class="col-8">
									<input type="text" class="form-control editor" name="name_ar" value="{{ $record->name_ar }}">
									@if($errors->has('name_ar'))
			                			@component('components.error')
			                				{{$errors->first('name_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
