@extends('layouts.admin_app')

@section('title','Admin Dashboard')

@section('content')
<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">View</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<table class="table table-striped view-table">
						    <tr>
						      	<td>Status</td>
						      	<td>@if($record->status==1) Active @else Deactive @endif</td>
						    </tr>
						    <tr>
						    	<td>Banner</td>
						    	<td>
						    		<img class="banner-image" src="{{ asset('/admin/images/banner_images/'.$record->banner) }}">
						    	</td>
						    </tr>
						    <tr>
						      	<td>Description (In English)</td>
						      	<td>{!! $record->text_eng !!}</td>
						    </tr>
						    <tr>
						      	<td>Description (In Arabic)</td>
						      	<td>{!! $record->text_ar !!}</td>
						    </tr>
						    <tr>
						      	<td>Created at</td>
						      	<td>{{\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')}}</td>
						    </tr>
						    <tr>
						      	<td colspan="2">
						      		<a href="{{ route('admin.list_banners',['type'=>$record->type]) }}" class="btn btn-primary">Back</a>
						      	</td>
						    </tr>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>
@endsection
