@extends('layouts.admin_app')

@section('title','Edit Banner - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Edit Banner</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-edit-banner') }}" enctype="multipart/form-data">
							{{@csrf_field()}}
							<input type="hidden" name="id" value="{{ $record->id }}">
							<input type="hidden" name="type" value="{{ $record->type }}">
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Banner Image</label>
								<div class="col-8">
									<input type="file" class="form-control input-image-upload" name="banner" >
									<div class="preview-image">
										<img src="{{ asset('/admin/images/banner_images/'.$record->banner) }}" alt="">
									</div>
									<input type="hidden" name="old_banner" value="{{ $record->banner }}">
									@if($errors->has('banner'))
			                			@component('components.error')
			                				{{$errors->first('banner')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Text on Banner (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="text_eng">{{ $record->text_eng }}</textarea>
									@if($errors->has('text_eng'))
			                			@component('components.error')
			                				{{$errors->first('text_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Text on Banner (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="text_ar">{{ $record->text_ar }}</textarea>
									@if($errors->has('text_ar'))
			                			@component('components.error')
			                				{{$errors->first('text_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
