@extends('layouts.admin_app')

@section('title','Add Banner - Admin Dashboard')

@section('content')


<main class="content">
	<div class="container-fluid p-0">
		<h1 class="h3 mb-3">Add Banner</h1>
		<div class="row">
			<div class="col-12">
				<div class="card">
					<!-- <div class="card-header">
						<h5 class="card-title mb-0"></h5>
					</div> -->
					<div class="card-body">
						@include('flash-message')
						<form method="POST" action="{{ route('submit-new-banner') }}" enctype="multipart/form-data">
							{{@csrf_field()}}
							<input type="hidden" name="type" value="{{ $type }}">
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Banner Image</label>
								<div class="col-8">
									<input type="file" class="form-control input-image-upload" name="banner" >
									<div class="preview-image" style="display: none;"></div>
									@if($errors->has('banner'))
			                			@component('components.error')
			                				{{$errors->first('banner')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Text on Banner (In English)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="text_eng">{{ old('text_eng') }}</textarea>
									@if($errors->has('text_eng'))
			                			@component('components.error')
			                				{{$errors->first('text_eng')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for="">Text on Banner (In Arabic)</label>
								<div class="col-8">
									<textarea class="form-control editor" name="text_ar">{{ old('text_ar') }}</textarea>
									@if($errors->has('text_ar'))
			                			@component('components.error')
			                				{{$errors->first('text_ar')}}
			                			@endcomponent
			                		@endif
								</div>
							</div>
							<div class="col-12 form-input-wrap mb-4">
								<label class="col-3" for=""></label>
								<div class="col-8">
									<input type="submit" name="Submit" value="submit" class="btn btn-primary">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
	
    <script>
    CKEDITOR.replaceAll( 'editor', {
        height: 200
    } );
    </script>
</main>
@endsection
