"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parser = exports.transformAST = void 0;
const wrapAstTransformation_1 = __importDefault(require("../src/wrapAstTransformation"));
const add_import_1 = require("./add-import");
const remove_extraneous_import_1 = require("./remove-extraneous-import");
// new Store() -> createStore()
const transformAST = (context) => {
    const { j, root } = context;
    const vuexImportDecls = root.find(j.ImportDeclaration, {
        source: {
            value: 'vuex',
        },
    });
    const importedVuex = vuexImportDecls.find(j.ImportDefaultSpecifier);
    const importedStore = vuexImportDecls.find(j.ImportSpecifier, {
        imported: {
            name: 'Store',
        },
    });
    if (importedVuex.length) {
        const localVuex = importedVuex.get(0).node.local.name;
        const newVuexDotStore = root.find(j.NewExpression, {
            callee: {
                type: 'MemberExpression',
                object: {
                    type: 'Identifier',
                    name: localVuex,
                },
                property: {
                    name: 'Store',
                },
            },
        });
        newVuexDotStore.replaceWith(({ node }) => {
            return j.callExpression(j.memberExpression(j.identifier(localVuex), j.identifier('createStore')), node.arguments);
        });
    }
    if (importedStore.length) {
        const localStore = importedStore.get(0).node.local.name;
        const newStore = root.find(j.NewExpression, {
            callee: {
                type: 'Identifier',
                name: localStore,
            },
        });
        add_import_1.transformAST(context, {
            specifier: {
                type: 'named',
                imported: 'createStore',
            },
            source: 'vuex',
        });
        newStore.replaceWith(({ node }) => {
            return j.callExpression(j.identifier('createStore'), node.arguments);
        });
        remove_extraneous_import_1.transformAST(context, { localBinding: localStore });
    }
};
exports.transformAST = transformAST;
exports.default = wrapAstTransformation_1.default(exports.transformAST);
exports.parser = 'babylon';
