<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Mail\WelcomeMail;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Facades\JWTFactory;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Tymon\JWTAuth\JWTManager as JWT;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Illuminate\Support\Facades\Mail;


class UserController extends Controller
{
    public function register(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'name'    => 'required|string|max:255',
            'email'   => 'required|string|email|max:255|unique:users',
            'address' =>'required',
            'contact_number'=>'required',
            'scfhs_number'=>'required',
            'workplace'=>'required',
            'profession'=>'required',
            'password'=> 'required|string|min:6|confirmed',
            'remember_me'=>'required'
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $json_data = $request->json();

        $data = [
            'name' => $json_data->get('name'),
            'email' => $json_data->get('email'),
            'address'=>$json_data->get('address'),
            'contact_number'=>$json_data->get('contact_number'),
            'scfhs_number'=>$json_data->get('scfhs_number'),
            'workplace'=>$json_data->get('workplace'),
            'profession'=>$json_data->get('profession'),
            'password' => Hash::make($json_data->get('password')),
        ];
        $user = User::create($data);

        $token = JWTAuth::fromUser($user);
        
        Mail::to($json_data->get('email'))->send(new WelcomeMail($data));

        return response()->json(compact('user','token'),200);
    }


    public function forget_password(Request $request){
        
        $validator = Validator::make($request->json()->all(), [
            'email'   => 'required|email',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        else{
            $data = $request->json()->all();
            $email = $request['email'];
            print_r($data);die;
        }
    }
    public function login(Request $request){
        $credentials = $request->json()->all();

        try {
            if(! $token = JWTAuth::attempt($credentials)){
                    return response()->json(['error'=>'Invalid Credentials'],400);
            }
        }catch (JWTException $e){
            return response()->json(['error'=>'could_not_create_token'],400);
        }

        return response()->json(compact('token'),200);

    }

    public function getAuthenticatedUser(){
        // header('Access-Control-Allow-Origin: *');
        /*header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS, post, get');
        header("Access-Control-Max-Age", "3600");
        header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
        header("Access-Control-Allow-Credentials", "true");*/

        try{
            if(!$user = JWTAuth::parseToken()->authenticate()){
                return response()->json(['user_not_found'], 400);
            }
        }catch (TokenExpiredException $e){
            return response()->json(['token_expired'], $e->getStatusCode());
        }catch (HttpException $e){
            return response()->json(['token_invalid'], $e->getStatusCode());
        }catch (HttpException $e){
            return response()->json(['token_absent'], $e->getStatusCode());
        }

        return response()->json(compact('user'),200);
    }
}