<?php


namespace App\Repositories;
use Str;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

use App\{
	User
};

class UserRepository 
{

	public function getAll() {
		return User::all();
	}
	public function getUser($id) {
		return User::find($id);
	}
	
	public function deleteUser($request,$id) {
		$user=User::find($id);
		$user->delete();
		$request->session()->flash('success','User Deleted Successfully');
		return redirect()->route('admin.list_users');
	}
	public function updateStatus($request) {
		$user=User::find($request->id);
		$user->status=$request->status;
		$user->save();
		return true;
	}
	public function save_new_user($request){
		$validator=Validator::make($request->all(),[
					'name'=>'required|string|max:255',
					'email'=>'required|unique:users|',
					'password'=>'required|confirmed',
					'contact_number'=>'required|numeric',
					'scfhs_number'=>'required',
					'workplace'=>'required',
					'profession'=>'required',
					'address'=>'required'
		]);
		if($validator->fails()) {
			/*var_dump($validator->errors());
			die;*/
			return redirect()->back()->withInput()->withErrors($validator->errors());
		}
		else{
			$user = User::create([
				'name'=>$request->name,
				'email'=>$request->email,
				'password'=>Hash::make($request->password),
				'address'=>$request->address,
				'contact_number'=>$request->contact_number,
				'scfhs_number'=>$request->scfhs_number,
				'workplace'=>$request->workplace,
				'profession'=>$request->profession,
				'status'=>1,
				'is_deleted'=>0
			]);
			$request->session()->flash('success','User created Successfully');
			return redirect()->route('admin.list_users');	
		}
	}
}
?>