<?php


namespace App\Repositories;
use PDF;
use Str;
use App\User;
use App\Mail\{
    OrderCreateMail, OrderCreateMailToAdmin
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

use App\Models\{
	Orders, OrderItems, Payments, UserMeta, Course
};

class OrderRepository {

	public function process_payment($request){

		$data = $request->all();
		$user_id = $data['user_id'];

		// create order
		$order = new Orders;
		$order->user_id = $user_id;
		$order->order_status = 0; // pending
		$order->sub_total = $data['sub_total'];
		$order->tax = $data['tax'];
		$order->total = $data['total'];
		$order->course_id = $data['course_id'];
		$order->save();
		$order_id = $order->id;

		// create order items

		/*foreach($data['cart_information'] as $cart_info){
			$course = Course::find($cart_info['id']);
			$order_item = new OrderItems;
			$order_item->order_id = $order_id;
			$order_item->course_id = $course->id;
			$order_item->qty = $cart_info['qty'];
			$order_item->amount = $course->amount;
			$order_item->total = $course->amount * $cart_info['qty'];
			$order_item->save(); 
		}*/

		// create entry in payments table

		$payment = new Payments;
		$payment->status = $data['payment_response']['status'];
		$payment->order_id = $order_id;
		$payment->tax_id = $data['payment_response']['id'];
		$payment->response = json_encode($data['payment_response'],true);
		$payment->save();

		// $usermeta = new UserMeta;
		// $usermeta->user_id = $user_id;
		// $usermeta->key = "billing_info_".$order_id;
		// $usermeta->value = json_encode($data['billing_information'],true);
		// $usermeta->save();

		return response()->json(array('status'=>true));

	}

	public function update_payment_status($request){
		$data = $request->all();
		$payment = Payments::where('tax_id',$data['id'])->first();
		$payment->status = $data['status'];
		$payment->save();

		if($data['status']=="failed"){
			$order = $this->get_complete_order($payment->order_id);
			$this->send_order_complete_email($payment->order_id);
		}
		
		return response()->json(array('status'=>true));
	}

	public function get_complete_order($order_id){
		return Orders::where('id',$order_id)->with('course')->with('buyer')->with('payment')->first();
	}

	public function send_order_complete_email($order_id){
		
		$order = $this->get_complete_order($order_id);
		
		$this->generate_invoice($order);
		$data = array(
			'order'=>$order,
			// 'usermeta'=>$usermeta,
			'pdf'=>public_path("invoices/Order-Invoice-".$order_id.".pdf")
		);
		// Mail::to('testuc22@gmail.com')->send(new OrderCreateMailToAdmin($data)); 
		Mail::to($order->buyer->email)->send(new OrderCreateMail($data)); 
		Mail::to(env('ADMIN_EMAIL'))->send(new OrderCreateMailToAdmin($data)); 
	}

	public function generate_invoice($order){
		PDF::SetTitle('Order Invoice');
		PDF::AddPage();
		$html = view('orders.order_invoice',compact('order'));
		PDF::writeHTML($html);
		$invoice_name = "Order-Invoice-".$order->id;
		PDF::Output(public_path("invoices/".$invoice_name.'.pdf'),"F");
		PDF::reset();
	}

	public function get_user_orders($user_id){
		$orders = Orders::where('user_id',$user_id)->with('payment')->get();
		return $orders;
	}
	public function check_course_booking($course_id,$user_id){
		$orders = Orders::where('user_id',$user_id)
						->where('course_id',$course_id)
						->with('payment')
						->whereHas('payment',function ($query) {
						        $query->where('status', '=', 'paid');
						    })
						->first();
		return $orders;
	}


}
?>