<?php


namespace App\Repositories;
use Str;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

use App\Models\{
	Course
};

class CourseRepository 
{

	public function delete(Request $request,$id){
        $record=Course::find($id);
        if (File::exists(public_path('/admin/images/course_images/'.$record->image))) {
            File::delete(public_path('/admin/images/course_images/'.$record->image));
        }

        $record->delete();
        $request->session()->flash('success','Course Deleted Successfully');
        return redirect()->route('admin.list_courses');
    }

	public function changeStatus(Request $request){
        $record = Course::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

	public function getCourse($id) {
		return Course::where('id',$id)->where('status',1)->first();
	} 

	public function save_new_record($request){
		$messages = [
		    'required' => 'This field is required.',
		];
		$validator=Validator::make($request->all(),[
					'name_eng'=>'required|unique:courses|string|max:255',
					'category'=>'required',
					'image'=>'required|image',
					'venue_eng'=>'required',
					'qty'=>'required|numeric',
					'start_date'=>'required',
					'end_date'=>'required',
					'amount'=>'required',
					'days'=>'required',
					'hours'=>'required',
					'about_course_eng'=>'required',
					'prerequisites_eng'=>'required',
					'package_includes_eng'=>'required',
		], $messages);
		if($validator->fails()) {
			
			return redirect()->back()->withInput()->withErrors($validator->errors());
		}
		else{
			$data = $request->all();

			unset($data['_token'],$data['Submit']);

			$imageName = "course-image-".time().'.'.$request->image->getClientOriginalExtension();
            $result = $request->image->move(public_path('/admin/images/course_images'), $imageName);

			$data['slug'] = Str::slug($request->name_eng, '-');
			$data['status'] = 1;
			$data['image'] = $imageName;

			$course = Course::create($data);
			$course->categories()->sync(array($request->category));
			$request->session()->flash('success','Course created Successfully');
			return redirect()->route('admin.list_courses');	
		}
	}

	public function save_edit_record($request){
		$messages = [
		    'required' => 'This field is required.',
		];
		$validator=Validator::make($request->all(),[
					'name_eng'=>'required|string|max:255',
					'category'=>'required',
					'image'=>'nullable|image',
					'venue_eng'=>'required',
					'qty'=>'required|numeric',
					'start_date'=>'required',
					'end_date'=>'required',
					'amount'=>'required',
					'days'=>'required',
					'hours'=>'required',
					'about_course_eng'=>'required',
					'prerequisites_eng'=>'required',
					'package_includes_eng'=>'required',
		], $messages);
		if($validator->fails()) {
			return redirect()->back()->withInput()->withErrors($validator->errors());
		}
		else{
			$data = $request->all();
			// print_r($data);die;
			$courseId = $data['id'];
			unset($data['id'],$data['_token'],$data['Submit'],$data['old_image'],$data['category']);
			if(!isset($data['disable_course'])){
				$data['disable_course'] = 0;
			}
			$record = Course::find($courseId);
            $imageName = $request->old_image;
            if(isset($request->image) && !empty($request->image)){
                $imageName = "course-image-".time().'.'.$request->image->getClientOriginalExtension();
                $result = $request->image->move(public_path('/admin/images/course_images'), $imageName);
                if (File::exists(public_path('/admin/images/course_images/'.$request->old_image))) {
                    File::delete(public_path('/admin/images/course_images/'.$request->old_image));
                }
            }

            foreach ($data as $key => $value) {
            	$record->$key = $value;
            }
            $record->slug = Str::slug($request->name_eng, '-');
            $record->image = $imageName;
            $record->save();
            $record->categories()->sync(array($request->category));
            $request->session()->flash('success','Course updated Successfully');
            return redirect()->route('admin.list_courses');
		}
	}
}
?>