<?php 
namespace App\Repositories;
use File;
use Illuminate\Http\Request;
use App\Models\{
	Category
};
use Session;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class CategoryRepository{

    public function __construct(){
        
    }

    public function get_return_url(){
        return redirect()->route('admin.list_categories');
    }

    public function getAllCategories(){
        return Category::where('parent', 0)
                ->with('children')
                ->get();
    }
    public function changeStatus($request){
        $record = Category::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

    public function filterAllCategories($request){
        DB::enableQueryLog();
        $catgory_name = ($request->has('category_name') && $request->has('category_name')!="") ? $request->has('category_name') : null;
        $categories = Category::when($catgory_name,function($query,$catgory_name){
            return $query->where('name','like','%'.$catgory_name.'%');
        })->get();
        $quries = DB::getQueryLog();
        return $categories;
    }

    public function getParentCategories($status=0){
        $category = Category::where('parent',0);
        if($status) {
            $category = $category->where('status',1);
        }
        return $category->orderBy('id','desc')->get();
    }

    public function getCategoryById($id){
        return Category::where('id',$id)->first();
    }

    public function save_new_record($request){
        $this->validateCategoryData($request);
        $categoryData=$this->getCategoryData($request);
        Category::create($categoryData);
        $request->session()->flash('success','Page created Successfully');
        return $this->get_return_url();
    }

    public function validateCategoryData($request){
        $request->validate([
        	'name_eng'=>'required',
            'name_ar'=>'required'
        ]);
    }

    public function getCategoryData($request){
        $arrayCat = array(
            'parent'=> $request->parent ? $request->parent : 0,
            'name_eng'=>$request->name_eng,
            'name_ar'=>$request->name_ar,
            'slug'=>Str::slug($request->name_eng, '-'),
            'status'=>1,
        );

        if($request->image){
            $imageName = "category-image-".time().'.'.$request->image->getClientOriginalExtension();
            $result = $request->image->move(public_path('/admin/images/category_images'), $imageName);
            $arrayCat['image'] = $imageName;
            if (File::exists(public_path('/admin/images/category_images/'.$request->old_image))) {
                    File::delete(public_path('/admin/images/category_images/'.$request->old_image));
                }
        }
        return $arrayCat;
    }

    public function save_edit_record($request){
        $this->validateCategoryData($request);
        $categoryData=$this->getCategoryData($request);
        $this->getCategoryById($request->id)->update($categoryData);
        $request->session()->flash('success','Category Updated Successfully');
        return $this->get_return_url();
    }

    public function deleteCategory($request,$id){
        $category = $this->getCategoryById($id);
        $image = $category->image;
        $category->delete();
        if (File::exists(public_path('/admin/images/category_images/'.$image))) {
            File::delete(public_path('/admin/images/category_images/'.$image));
        }
        $affected = DB::table('categories')
              ->where('parent',$id)
              ->update(['parent' => 0]);

        $request->session()->flash('success','Category Deleted Successfully');
        return $this->get_return_url();
    }

    public function getChildCategories($category=0){
        return Category::where('parent',$category)->get();
    }

    public function getCategoriesDropdown($categoryIDs=array(),$status = 0){
        $allCategories = $this->getParentCategories($status);

        $html = '';
        foreach ($allCategories as $key => $cat) {
            $selected = "";
            if($categoryIDs && in_array($cat->id, $categoryIDs)){
                $selected = "selected";
            }
            $html .= '<option value="'.$cat->id.'" '.$selected.'>'.$cat->name_eng.'</option>';
            $categoriesHTML = $this->getChildOptions($cat,$cat->name_eng,$categoryIDs);

            $html .= $categoriesHTML;
        }
        // $html .= '</select>';
        return $html;
    }
    public function getChildOptions($cat,$current_cat,$categoryIDs=array()){
        $html = '';
        $categories = $this->getChildCategories($cat->id);
        if(!empty($categories)){
            foreach($categories as $category){
                $current_cat_1 = $current_cat." >> ".$category->name_eng;
                $selected = "";
                if($categoryIDs && in_array($category->id, $categoryIDs)){
                    $selected = "selected";
                }
                $html .= '<option value="'.$category->id.'"  '.$selected.'>'.$current_cat_1.'</option>';
                $categories = $this->getChildOptions($category,$current_cat_1,$categoryIDs);
                $html .= $categories;
            }
        }
        return $html;
    }

    public function getCategoriesWithConditions($ids=array()){
        $category = Category::where('status',1);
        if(!empty($ids)){
            $category = $category->whereIn('id',$ids);
        }
        return $category->get();
    }


    

}
