<?php


namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;

class Orders extends Model
{
    protected $fillable = [
        'id','user_id','course_id','order_status','sub_total','tax','total'
    ];

    public function buyer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
    public function payment()
    {
        return $this->hasOne(Payments::class, 'order_id');
    }

    public function order_items()
    {
        return $this->hasMany(OrderItems::class, 'order_id');
    }
}
