<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    public $fillable = [
        'status','disable_course','name_eng','name_ar','slug','venue_eng','venue_ar','image','start_date','end_date','amount','days','hours','qty','about_course_eng','about_course_ar','prerequisites_eng','prerequisites_ar','package_includes_eng','package_includes_ar','speakers','curriculum','view_count','meta_title','meta_description','meta_keywords'
    ];


    public function categories(){
        return $this->belongsToMany(Category::class, 'course_categories', 'course_id', 'category_id');
    }
}
