<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;

class Category extends Model
{


    public $fillable = [
    	'parent','name_eng','name_ar','slug','image','status','meta_title','meta_tags','meta_desc'
    ];

    public function courses()
    {
        return $this->belongsToMany(Category::class, 'course_categories', 'category_id', 'course_id');
    }

    public function subChildren()
	{
	  return $this->hasMany(Category::class, 'parent');
	}

	public function children()
	{
	    return $this->hasMany(Category::class, 'parent')->with('subChildren');
	}
	public function parent_category()
    {
        return $this->belongsTo(Category::class, 'parent');
    }
}
