<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderCreateMailToAdmin extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        $subject = "New Order Placed!";
        return $this->view('emails.order.new_order_to_admin')
                    ->subject($subject)
                    ->with([ 'data' => $this->data ])
                    ->attach($this->data['pdf']);
    }
}
