<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderCreateMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        $subject = "Order Created Successfully!";
        return $this->view('emails.order.new_order')
                    ->subject($subject)
                    ->with([ 'data' => $this->data ])
                    ->attach($this->data['pdf']);
    }
}
