<?php

namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use Route;
class AdminLoginController extends Controller{
   
    public function __construct(){
        $this->middleware('guest:admin', ['except' => ['logout']]);
    }
    
    public function showLoginForm(){
        
        return view('auth.admin_login');
    }
    
    public function login(Request $request){
      // Validate the form data
      
        $this->validate($request, [
            'email'   => 'required|email',
            'password' => 'required|min:6'
        ]);
        
        if (Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password])) {
            // if successful, then redirect to their intended location
            return redirect()->intended(route('admin.dashboard'));
        } 

        // if unsuccessful, then redirect back to the login with the form data
        $request->session()->flash('error', 'Wrong Credentials');
        return redirect()->back()->withInput($request->only('email', 'remember'));
    }
    
    public function logout(Request $request){
        Auth::guard('admin')->logout();
        $request->session()->flash('success', 'Logged out successfully');
        return redirect('/admin/login');
    }
}