<?php

namespace App\Http\Controllers\Api;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Mail; 
use App\Mail\{
    WelcomeMail
};
use Illuminate\Support\Str;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Facades\JWTFactory;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Tymon\JWTAuth\JWTManager as JWT;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use App\Http\Controllers\Controller;
use DB; 
use Carbon\Carbon;

class UserController extends Controller
{
    public function register(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'name'    => 'required|string|max:255',
            'email'   => 'required|string|email|max:255|unique:users',
            'address' =>'required',
            'contact_number'=>'required',
            'scfhs_number'=>'required',
            'workplace'=>'required',
            'profession'=>'required',
            'password'=> 'required|string|min:6|confirmed',
            'remember_me'=>'required'
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $json_data = $request->json();

        $data = [
            'name' => $json_data->get('name'),
            'email' => $json_data->get('email'),
            'address'=>$json_data->get('address'),
            'contact_number'=>$json_data->get('contact_number'),
            'scfhs_number'=>$json_data->get('scfhs_number'),
            'workplace'=>$json_data->get('workplace'),
            'profession'=>$json_data->get('profession'),
            'password' => Hash::make($json_data->get('password')),
        ];
        $user = User::create($data);

        $token = JWTAuth::fromUser($user);
        
        // Mail::to($json_data->get('email'))->send(new WelcomeMail($data));

        return response()->json(compact('user','token'),200);
    }


    public function forget_password(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'email'   => 'required|email',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        else{
            $user =  User::where('email',$request['email'])->first();
            if(!empty($user)){
                $data = $request->json()->all();
                $email = $request['email'];
                $token = Str::random(64);
                DB::table('password_resets')->insert([
                    'email' => $request->email, 
                    'token' => $token, 
                    'created_at' => Carbon::now()
                ]);
                $url = "https://namamedical.org/reset-password-form/".$token.'/';
                Mail::send('emails.forgetPassword', ['url' => $url], function($message) use($request){
                    $message->to($request->email);
                    $message->subject('Reset Password');
                });
                return response()->json(array('message'=>"Please check your email to reset password."),200);
            }
            else{
                return response()->json(array('message'=>"User doesn't exist." ),400);
            }
        }
    }

    public function reset_password(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'password'   => 'required|string|min:6|confirmed',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        else{
            $record = DB::table('password_resets')->where('token', $request['token'])->first();
            if(!empty($record)){
                $user = User::where('email',$record->email)->first();
                if(!empty($user)){
                    DB::table('users')
                        ->where('id', $user->id)
                        ->update(array('password' => Hash::make($request['password'])));

                    DB::table('password_resets')->where('token', $request['token'])->delete();
                    return response()->json(array('message'=>"Password reset successfully"),200);
                }
                else{
                    return response()->json(array('message'=>"User doesn't exist." ),400);
                }
            }
            else{
                return response()->json(array('message'=>"Token expired." ),400);
            }
        }
    }
    public function login(Request $request){
        $credentials = $request->json()->all();
        try {
            if(! $token = JWTAuth::attempt($credentials)){
                $error = array(
                    'Invalid Credentials'
                );
                $user = auth()->user();
                return response()->json(compact('user','error'),400);
            }
        }catch (JWTException $e){
            $error = array(
                'Some error occured while login!'
            );
            return response()->json(compact('error'),400);
        }
        $user = auth()->user();
        return response()->json(compact('token','user'),200);
    }

    public function google_login(Request $request){
        
    }

    public function getAuthenticatedUser(){
        // header('Access-Control-Allow-Origin: *');
        /*header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS, post, get');
        header("Access-Control-Max-Age", "3600");
        header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
        header("Access-Control-Allow-Credentials", "true");*/
        try{
            if(!$user = JWTAuth::parseToken()->authenticate()){
                return response()->json(['user_not_found'], 400);
            }
        }catch (TokenExpiredException $e){
            return response()->json(['token_expired'], $e->getStatusCode());
        }catch (HttpException $e){
            return response()->json(['token_invalid'], $e->getStatusCode());
        }catch (HttpException $e){
            return response()->json(['token_absent'], $e->getStatusCode());
        }
        return response()->json(compact('user'),200);
    }

    public function edit_profile(Request $request){
        $data = $request->all();
        $validator = Validator::make($request->json()->all(), [
            'name'    => 'required|string|max:255',
            'email'   => 'required|string|email|max:255|unique:users,email,'.$data['id'],
            'address' =>'required',
            'contact_number'=>'required',
            'scfhs_number'=>'required',
            'workplace'=>'required',
            'profession'=>'required'
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $json_data = $request->json();

        $user = User::find($data['id']);
        $user->name = $json_data->get('name');
        $user->email = $json_data->get('email');
        $user->address = $json_data->get('address');
        $user->contact_number = $json_data->get('contact_number');
        $user->scfhs_number = $json_data->get('scfhs_number');
        $user->workplace = $json_data->get('workplace');
        $user->profession = $json_data->get('profession');

        $user->save();

        $token = JWTAuth::fromUser($user);
        
        // Mail::to($json_data->get('email'))->send(new WelcomeMail($data));

        return response()->json(compact('user','token'),200);
    }
}