<?php

namespace App\Http\Controllers\Api;

use App\Models\{
    Page,Faq,Settings
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\JWTManager as JWT;

use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class PagesController extends Controller
{
    public function get_page(Request $request){
        $slug = $request->slug;
        $data = Page::where('slug',$slug)->first();
        return response()->json(compact('data'),200);
    }
    public function faq(Request $request){
        $data = Faq::where('status',1)->get();
        return response()->json(compact('data'),200);
    }
    public function contact_settings(Request $request){
        $record = Settings::where('meta_key','contact_us')->first();
        $data = json_decode($record['meta_description'],true);
        return response()->json(compact('data'),200);
    }
}