<?php

namespace App\Http\Controllers\Api;

use App\Models\{
    News
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\JWTManager as JWT;

use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class NewsController extends Controller
{
    public function listing(Request $request){
        $data = News::where('status',1);
        if(isset($request->search) && $request->search!=false){
            $data = $data->where('title_eng', 'like', '%'.$request->search.'%')
                        ->orWhere('title_ar', 'like', '%'.$request->search.'%')
                        ->orWhere('description_eng', 'like', '%'.$request->search.'%')
                        ->orWhere('description_ar', 'like', '%'.$request->search.'%');
        }
        // return print_r(request()->all());
        $data = $data->orderBy('id','desc')->paginate(10);
        $data = $data->appends(request()->all());
        return response()->json(compact('data'),200);
    }
    public function news_details(Request $request){
        $data = News::where('status',1)
                        ->where('slug',$request->slug)
                        ->first();

        $news=News::find($data->id);
        $news->view_count = $data->view_count+1;
        $news->save();
        return response()->json(compact('data'),200);
    }
    public function latest_news(Request $request){
        $data = News::where('status',1)
                    ->orderBy('id','desc')
                    ->limit(3)
                    ->get();
        return response()->json(compact('data'),200);
    }
    public function popular_news(Request $request){
        $data = News::where('status',1)
                    ->orderBy('view_count','desc')
                    ->limit(5)
                    ->get();
        return response()->json(compact('data'),200);
    }

}