<?php

namespace App\Http\Controllers\Api;

use App\Models\{
    Course, Category, UserMeta
};
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\JWTManager as JWT;
use App\Repositories\{
    CourseRepository,OrderRepository
};
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class CourseController extends Controller
{
    public function __construct(CourseRepository $course_repository, OrderRepository $order_repository){
        $this->course_repository = $course_repository;
        $this->order_repository = $order_repository;
    }
    public function listing(Request $request){
        $data = Course::where('status',1);
        if(isset($request->dateRange) && $request->dateRange['startDate']){
            $start_date = date('Y-m-d',strtotime($request->dateRange['startDate']));
            $end_date = date('Y-m-d',strtotime($request->dateRange['endDate']));
            $data = $data->where(function($query) use ($start_date, $end_date){
                            $query->whereBetween('start_date', [$start_date,$end_date])
                                    ->orWhereBetween('end_date', [$start_date,$end_date]);
                        });
        }
        if(isset($request->search_input) && $request->search_input!=""){
            $search = $request->search_input;
            $data = $data->where('name_eng', 'like', '%'.$search.'%')
                                ->orWhere('name_ar', 'like', '%'.$search.'%')
                                ->orWhere('about_course_eng', 'like', '%'.$search.'%')
                                ->orWhere('about_course_ar', 'like', '%'.$search.'%')
                                ->orWhere('venue_eng', 'like', '%'.$search.'%')
                                ->orWhere('venue_ar', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_eng', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_ar', 'like', '%'.$search.'%')
                                ->orWhere('package_includes_eng', 'like', '%'.$search.'%')
                                ->orWhere('package_includes_ar', 'like', '%'.$search.'%');
        }
        // return print_r(request()->all());
        $data = $data->orderBy('id','desc')->paginate(2);
        $data = $data->appends(request()->all());
        return response()->json(compact('data'),200);
    }
    public function course_details(Request $request){
        $data = Course::where('status',1)
                        ->where('slug',$request->slug)
                        ->first();
        $record = Course::find($data->id);
        $record->view_count = $record->view_count+1;
        $record->save();
        return response()->json(compact('data'),200);
    }
    public function search(Request $request){
        $data = Course::where('status',1);
        return print_r(request()->all());
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $data = $data->where('name_eng', 'like', '%'.$search.'%')
                                ->orWhere('name_ar', 'like', '%'.$search.'%')
                                ->orWhere('about_course_eng', 'like', '%'.$search.'%')
                                ->orWhere('about_course_ar', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_eng', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_ar', 'like', '%'.$search.'%');
        }
        $data = $data->orderBy('id','desc')->paginate(2);
        $data = $data->appends(request()->all());
        return response()->json(compact('data'),200);
    }
    public function popular_courses(Request $request){
        $data = Course::where('status',1)
                    ->orderBy('view_count','desc')
                    ->limit(6)
                    ->get();
        return response()->json(compact('data'),200);
    }

    public function get_courses_by_category(Request $request){
        //echo $request->cat;
        /*$data = Course::whereHas('categories', function (Builder $query) use ($request){
            $query->where('slug',$request->cat);
        })->get();*/
        $limit = $request->cat ? $request->cat : -1;
        $data = Course::where('status',1)->orderBy('end_date','desc');
        if($limit > 0){
            $data = $data->limit($limit);
        }
        $data = $data->get();
        return response()->json(compact('data'),200);
    }
    public function get_course_qty(Request $request){
        $record = $this->course_repository->getCourse($request->course_id);
        return response()->json(array('qty'=>$record->qty),200);
    }

    public function orders(Request $request){
        $data = $request->all();
        $user_id = $data['id'];
        $orders = $this->order_repository->get_user_orders($user_id);
        return response()->json(array('orders'=>$orders),200);
    }

    public function order_details(Request $request){
        $data = $request->all();
        $order = $this->order_repository->get_complete_order($data['order_id']);
        if($order->user_id == $data['user_id']){
            
            return response()->json(array('order'=>$order),200);
        }
        else{
            return response()->json(array('status'=>'error'),400);           
        }
    }
    public function check_course_booking(Request $request){
        $data = $request->all();
        $order = $this->order_repository->check_course_booking($data['course_id'],$data['user_id']);
        $already_registered = false;
        if(empty($order)){
            $already_registered = false;
        }
        elseif($order->payment->status=="failed"){
            $already_registered = false;   
        }
        else{
            $already_registered = true;
        }

        return response()->json(array('already_registered'=>$already_registered),200);
    }

}