<?php

namespace App\Http\Controllers\Api;
use App\User;
use App\Models\{
    Subscriber,
    Banner,
    Page,
    Course
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\JWTManager as JWT;
use App\Mail\{
    BookingMail,ContactMail,CourseRegisterMail  
};
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class CommonController extends Controller
{
    public function subscribe(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'email'   => 'required|string|email|max:255|unique:subscribers',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $json_data = $request->json();

        $data = [
            'email' => $json_data->get('email'),
        ];
        $user = Subscriber::create($data);
        return true;
    }

    public function get_banner_images(Request $request){
        $page = $request->slug;
        $banners = Banner::where('type',$page)->where('status',1)->orderBy('id', 'desc')->get();
        return response()->json(compact('banners'),200);
    }
    public function book_demo(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'name'   => 'required|string|max:255',
            'email'   => 'required|string|email|max:255',
            'contact_number'   => 'required|numeric',
            'workplace'   => 'required',
            'program'   => 'required',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $data = $request->all();
        Mail::to('sales@namamedical.org')->send(new BookingMail($data));
        $resp = array('status'=>'success');
        return response()->json(compact('resp'),200);
    }
    public function contact(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'name'   => 'required|string|max:255',
            'email'   => 'required|string|email|max:255',
            'contact_number' =>  'nullable|numeric',
            'message'   => 'required',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $data = $request->all();

        Mail::to('help@namamedical.org')->send(new ContactMail($data));
        $resp = array('status'=>'success');
        return response()->json(compact('resp'),200);
    }
    public function course_register(Request $request){
        $validator = Validator::make($request->json()->all(), [
            'name'           => 'required|string|max:255',
            'scfhs_number'   => 'required',
            'profession'       => 'required',
            'workplace'  => 'required',
            'contact_number'  => 'required|numeric',
            'email'          => 'required|string|email|max:255'
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $data = $request->all();

        $json_data = $request->json();

        $user = User::find($data['id']);
        $user->name = $json_data->get('name');
        $user->email = $json_data->get('email');
        $user->contact_number = $json_data->get('contact_number');
        $user->scfhs_number = $json_data->get('scfhs_number');
        $user->workplace = $json_data->get('workplace');
        $user->profession = $json_data->get('profession');

        print_r($user);
        // $user->save();

        $token = JWTAuth::fromUser($user);



        // Mail::to('support@namamedical.org')->send(new CourseRegisterMail($data));
        $resp = array('status'=>'success');
        return response()->json(compact('resp','user','token'),200);
    }

    public function get_meta_information(Request $request){
        //dd('hello');
        $data = $request->all();
       // dd($data);
        //die();
        $response = array();
        $response = array(   // default values
            'meta_title' => "NAMA MEDICAL TRAINING CENTER",
            'meta_description' => "NAMA MEDICAL TRAINING CENTER",
            'meta_keywords' =>"NAMA MEDICAL TRAINING CENTER"
        );

        $page_slug = $data['slug'];

        if($data['type']=="page"){
            $page_slug = $page_slug == "/" ? "home" : str_replace("/", "" , $page_slug);
            $row = Page::where('slug',$page_slug)->where('status',1)->first();
            if(!empty($row)){
                $response = array(
                    'meta_title' =>$row->meta_title,
                    'meta_description' =>$row->meta_description,
                    'meta_keywords' =>$row->meta_keywords
                );
            }
        }
        else{
            $page_slug = str_replace("/","",str_replace("/courses/", "" , $data['name']));
            $row = Course::where('slug',$page_slug)->where('status',1)->first();
            if(!empty($row)){
                $response = array(
                    'meta_title' =>$row->meta_title,
                    'meta_description' =>$row->meta_description,
                    'meta_keywords' =>$row->meta_keywords
                );
            }
        }
        return response()->json(compact('response'),200);
    }
}