<?php

namespace App\Http\Controllers\Api;

use App\Models\{
    Course, Category, Settings
};
use App\Repositories\{
    CourseRepository, OrderRepository
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;

class CheckoutController extends Controller
{
    public function __construct(CourseRepository $course_repository, OrderRepository $order_repository){
        $this->course_repository = $course_repository;
        $this->order_repository = $order_repository;
    }

    public function send_order_complete_email(){
        $order = $this->order_repository->send_order_complete_email(1);
        print_r($order);die;
    }
    public function validate_billing_address(Request $request){
        // $data = $request->all();
        // print_r($data);
        $validator = Validator::make($request->json()->all(), [
            'first_name'    => 'required|string|max:255',
            'last_name'   => 'required|string|max:255',
            'phone' =>'required|numeric',
            'address_1'=>'required',
            'address_2'=>'required',
            'state'=>'required',
            'city'=>'required',
            'zipcode'=> 'required|string',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        return response()->json(array('status'=>'valid'),200);
    }

    public function process_payment(Request $request){
        return $this->order_repository->process_payment($request);
    }

    public function update_payment_status(Request $request){
        return $this->order_repository->update_payment_status($request);
    }
}