<?php

namespace App\Http\Controllers\Api;

use App\Models\{
    Course, Category, Settings
};
use App\Repositories\{
    CourseRepository
};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;

class CartController extends Controller
{
    public function __construct(CourseRepository $course_repository){
        $this->course_repository = $course_repository;
    }
    public function get_cart_items(Request $request){
        $data = $request->all();
        if(!empty($data['items'])){
            foreach($data['items'] as $key=> &$item){
                $course = $this->course_repository->getCourse($item['id']);
                if(!empty($course)){
                    $item['details'] = $course;
                }
                else{
                    $item['details'] = false;   
                }
            }
        }
        return response()->json(compact('data'),200);
    }
    public function get_tax_percentage(Request $request){
        $settings = Settings::where('meta_key','global_settings')->first();
        $settings = json_decode($settings['meta_description'],true);
        return response()->json(array('tax'=>$settings['cart_tax']),200);
    }
}