<?php

namespace App\Http\Controllers\Admin;
use App\User;

use App\Repositories\UserRepository;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class UsersController extends Controller {

    public function __construct(UserRepository $user_repository){
        $this->user_repository = $user_repository;
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status='';
        $allUsers = User::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $allUsers = $allUsers->where('name', 'like', '%'.$search.'%')
                                ->orWhere('email', 'like', '%'.$search.'%')
                                ->orWhere('contact_number', 'like', '%'.$search.'%')
                                ->orWhere('workplace', 'like', '%'.$search.'%')
                                ->orWhere('address', 'like', '%'.$search.'%')
                                ->orWhere('profession', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $allUsers = $allUsers->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;

        $allUsers = $rows=="all" ? $allUsers->paginate(9999999)->withQueryString() : $allUsers->paginate($rows)->withQueryString();

        return view('admin.users.list',compact('allUsers','search','rows','status'));
    }

    public function delete_user(Request $request,$id){
        return $this->user_repository->deleteUser($request,$id);
    }

    public function view_user(Request $request,$id){
        $user = $this->user_repository->getUser($id);
        return view('admin.users.view',compact('user'));
    }
    public function add_user(Request $request){
        return view('admin.users.add');
    }
    public function save_new_user(Request $request){
        return $this->user_repository->save_new_user($request);
    }
    public function changeUserStatus(Request $request){
        return $this->user_repository->updateStatus($request);
    }
}
