<?php
namespace App\Http\Controllers\Admin;

use App\Models\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use Illuminate\Support\Facades\Validator;

class SettingsController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function contact_settings(Request $request){
        $record = Settings::where('meta_key','contact_us')->first();
        $record = json_decode($record['meta_description'],true);
        return view('admin.settings.contact_us',compact('record'));
    }
    public function save_contact_settings(Request $request){
        $settings = $request->settings;
        $members_info = array();
        if(isset($settings['members']['title_eng'][0])){
            for($i=0;$i<count($settings['members']['title_eng']);$i++){
                $members_info[$i]['title_eng'] = $settings['members']['title_eng'][$i];
                $members_info[$i]['title_ar'] = $settings['members']['title_ar'][$i];
                $members_info[$i]['name_eng'] = $settings['members']['name_eng'][$i];
                $members_info[$i]['name_ar'] = $settings['members']['name_ar'][$i];
                $members_info[$i]['email'] = $settings['members']['email'][$i];
            }
        }
        $data = array(
            'members_info'=>$members_info,
            'contact_info_eng'=>$settings['contact_info_eng'],
            'contact_info_ar'=>$settings['contact_info_ar'],
        );
        $record = Settings::find(1);
        $record->meta_description = json_encode($data);
        $record->save();
        $request->session()->flash('success','Data updated Successfully');
        return redirect()->route('admin.contact_settings');
    }
     public function global_settings(Request $request){
        $settings = Settings::where('meta_key','global_settings')->first();
        $settings = json_decode($settings['meta_description'],true);
        return view('admin.settings.global_settings',compact('settings'));        
    }
    public function save_global_settings(Request $request){
        $settings = $request->settings;
        $data = array(
            'cart_tax'=>$settings['cart_tax']
        );
        $record = Settings::where('meta_key','global_settings')->first();
        $record->meta_description = json_encode($data);
        $record->save();
        $request->session()->flash('success','Data updated Successfully');
        return redirect()->route('admin.global_settings');
    }
}
