<?php
namespace App\Http\Controllers\Admin;

use App\Models\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use Illuminate\Support\Facades\Validator;

class PagesController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status = '';
        $records = Page::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('heading_eng', 'like', '%'.$search.'%')
                                ->orWhere('description_eng', 'like', '%'.$search.'%')
                                ->orWhere('heading_ar', 'like', '%'.$search.'%')
                                ->orWhere('description_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;
        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();
        return view('admin.pages.list',compact('records','search','rows','status'));
    }

    public function add(Request $request){
        return view('admin.pages.add');
    }

    public function save_new_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'heading_eng'=>'required|unique:pages',
                    'description_eng'=>'required'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = Page::create([
                'slug'=>Str::slug($request->heading_eng, '-'),
                'heading_eng'=>$request->heading_eng,
                'description_eng'=>$request->description_eng,
                'meta_title' => $request->meta_title ? $request->meta_title : null,
                'meta_description' => $request->meta_description ? $request->meta_description : null,
                'meta_keywords' => $request->meta_keywords ? $request->meta_keywords : null,
                'status'=>1,
            ]);
            $request->session()->flash('success','Page created Successfully');
            return redirect()->route('admin.list_pages');   
        }
    }

    public function changeStatus(Request $request){
        $record = Page::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

    public function delete(Request $request,$id){
        $record=Page::find($id);
        $record->delete();
        $request->session()->flash('success','Page Deleted Successfully');
        return redirect()->route('admin.list_pages');
    }

    public function view(Request $request,$id){
        $record = Page::find($id);
        return view('admin.pages.view',compact('record'));
    }

    public function edit(Request $request,$id){
        $record = Page::find($id);
        return view('admin.pages.edit',compact('record','id'));
    }

    public function save_edit_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'heading_eng'=>'required',
                    'description_eng'=>'required',
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = Page::find($request->id);
            // $record->slug = Str::slug($request->heading_eng, '-');
            $record->heading_eng = $request->heading_eng;
            $record->description_eng = $request->description_eng;

            $record->meta_title = $request->meta_title ? $request->meta_title:null;
            $record->meta_description = $request->meta_description ? $request->meta_description : null;
            $record->meta_keywords = $request->meta_keywords ? $request->meta_keywords : null;
            $record->save();
            $request->session()->flash('success','Page updated Successfully');
            return redirect()->route('admin.list_pages');   
        }
    }
}
