<?php

namespace App\Http\Controllers\Admin;
use App\Models\{ 
    Course,Category,Orders, UserMeta
};

use App\Repositories\OrderRepository;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class OrdersController extends Controller {

    public function __construct(OrderRepository $order_repository){
        $this->order_repository = $order_repository;
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status='';
        $records = Orders::orderBy('id','DESC')->with('payment'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('id', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;

        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();

        return view('admin.orders.list',compact('records','search','rows','status'));
    }

    public function view_order_details(Request $request,$id){
        $record = $this->order_repository->get_complete_order($id);
        // print_r($record);die;
        return view('admin.orders.view',compact('record'));
    }


    
}
